# Laravel DataTables Editor Plugin.

[![Laravel 11](https://img.shields.io/badge/Laravel-11-orange.svg)](http://laravel.com)
[![Latest Stable Version](https://img.shields.io/packagist/v/yajra/laravel-datatables-editor.svg)](https://packagist.org/packages/yajra/laravel-datatables-editor)

[![Continuous Integration](https://github.com/yajra/laravel-datatables-editor/actions/workflows/continuous-integration.yml/badge.svg)](https://github.com/yajra/laravel-datatables-editor/actions/workflows/continuous-integration.yml)
[![Static Analysis](https://github.com/yajra/laravel-datatables-editor/actions/workflows/static-analysis.yml/badge.svg)](https://github.com/yajra/laravel-datatables-editor/actions/workflows/static-analysis.yml)

[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/yajra/laravel-datatables-editor/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/yajra/laravel-datatables-editor/?branch=master)
[![Total Downloads](https://img.shields.io/packagist/dt/yajra/laravel-datatables-editor.svg)](https://packagist.org/packages/yajra/laravel-datatables-editor)
[![License](https://img.shields.io/github/license/mashape/apistatus.svg)](https://packagist.org/packages/yajra/laravel-datatables-editor)

This package is a plugin of [Laravel DataTables](https://github.com/yajra/laravel-datatables) for processing [DataTables Editor](https://editor.datatables.net/) library.

> Special thanks to [@bellwood](https://github.com/bellwood) and [@DataTables](https://github.com/datatables) for being [generous](https://github.com/yajra/laravel-datatables/issues/1548) for providing a license to support the development of this package.

**NOTE:** A [premium license](https://editor.datatables.net/purchase/index) is required to be able to use [DataTables Editor](https://editor.datatables.net/) library.

## Requirements

- [Laravel 11.x](https://github.com/laravel/framework)
- [Laravel DataTables 11.x](https://github.com/yajra/laravel-datatables)

## Documentations

- [Laravel DataTables Editor Manual](https://yajrabox.com/docs/laravel-datatables/editor-installation)
- [jQuery DataTables Editor Manual](https://editor.datatables.net/manual/index)

## Laravel Version Compatibility

| Laravel | Package |
|:--------|:--------|
| 5-10    | 1.x     |
| 11.x    | 11.x    |

## Features

- DataTables Editor CRUD actions supported.
- Inline editing.
- Bulk edit & delete function.
- CRUD validation.
- CRUD pre / post events hooks.
- Artisan command for DataTables Editor generation.

## Quick Installation

`composer require yajra/laravel-datatables-editor:^11`

And that's it! Start building out some awesome DataTables Editor!

## Contributing

Please see [CONTRIBUTING](https://github.com/yajra/laravel-datatables-editor/blob/master/.github/CONTRIBUTING.md) for details.

## Security

If you discover any security related issues, please email [aqangeles@gmail.com](mailto:aqangeles@gmail.com) instead of using the issue tracker.

## Credits

- [Arjay Angeles](https://github.com/yajra)
- [All Contributors](https://github.com/yajra/laravel-datatables-editor/graphs/contributors)

## License

The MIT License (MIT). Please see [License File](https://github.com/yajra/laravel-datatables-editor/blob/master/LICENSE.md) for more information.
