<?php

// phpcs:ignorefile

declare(strict_types=1);

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * This class is auto generated from the Infobip OpenAPI specification through the OpenAPI Specification Client API libraries (Re)Generator (OSCAR), powered by the OpenAPI Generator (https://openapi-generator.tech).
 *
 * Do not edit manually. To learn how to raise an issue, see the CONTRIBUTING guide or contact us @ support@infobip.com.
 */

namespace Infobip\Model;

use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation as Serializer;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use Symfony\Component\Serializer\Annotation\DiscriminatorMap;

class SmsBinaryContent implements ModelInterface
{
    public const DISCRIMINATOR = '';
    public const OPENAPI_MODEL_NAME = 'SmsBinaryContent';

    public const OPENAPI_FORMATS = [
        'dataCoding' => 'int32',
        'esmClass' => 'int32',
        'hex' => null
    ];

    /**
     */
    public function __construct(
        #[Assert\NotBlank]

    protected string $hex,
        protected ?int $dataCoding = null,
        protected ?int $esmClass = null,
    ) {
    }

    #[Ignore]
    public function getModelName(): string
    {
        return self::OPENAPI_MODEL_NAME;
    }

    #[Ignore]
    public static function getDiscriminator(): ?string
    {
        return self::DISCRIMINATOR;
    }

    public function getDataCoding(): int|null
    {
        return $this->dataCoding;
    }

    public function setDataCoding(?int $dataCoding): self
    {
        $this->dataCoding = $dataCoding;
        return $this;
    }

    public function getEsmClass(): int|null
    {
        return $this->esmClass;
    }

    public function setEsmClass(?int $esmClass): self
    {
        $this->esmClass = $esmClass;
        return $this;
    }

    public function getHex(): string
    {
        return $this->hex;
    }

    public function setHex(string $hex): self
    {
        $this->hex = $hex;
        return $this;
    }
}
