
<?php $__env->startSection('page_title', __('Manage Menu')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Frontend'); ?></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Manage Menu'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Manage Menu'); ?></h1>
                </div>
            </div>
        </div>


        <div class="d-flex justify-content-between align-items-center">
            <h3 class="ms-1 "><?php echo app('translator')->get("Manage Menu For Header"); ?></h3>
            <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal"
                    data-bs-target="#addCustomLinkModal">
                Add Custom Links
            </button>
        </div>

        <div class="row" id="manage-menu">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title h4"><?php echo app('translator')->get('Pages'); ?></h2>
                    </div>
                    <div class="card-body bg-soft-secondary">
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="js-sortable sortablejs-custom list-group drop-pages listed_arr"
                                data-hs-sortable-options='{
                                       "animation": 150,
                                       "group": {
                                         "name": "MenuSorting",
                                         "pull": "clone",
                                         "put": false
                                       }
                                     }'>
                                <div class="list-group-item mb-2">
                                    <div class="d-flex justify-content-between align-items-center drop-content">
                                        <span> <?php echo app('translator')->get(ucwords(optional($page->details)->name ?? $page->name)); ?></span>
                                        <i class="fa-light"></i>
                                        <?php if($page->type == 3): ?>
                                            <div class="dropdown">
                                                <button type="button"
                                                        class="btn btn-ghost-secondary btn-icon btn-sm rounded-circle"
                                                        id="contentActivityStreamDropdown" data-bs-toggle="dropdown"
                                                        aria-expanded="false">
                                                    <i class="bi-three-dots-vertical"></i>
                                                </button>

                                                <div class="dropdown-menu dropdown-menu-end mt-1"
                                                     aria-labelledby="contentActivityStreamDropdown" style="">
                                                    <a class="dropdown-item edit_custom_btn" data-bs-toggle="modal"
                                                       data-bs-target="#editCustomLinkModal"
                                                       data-route="<?php echo e(route("admin.update.custom.link", $page->id)); ?>"
                                                       data-name="<?php echo e(optional($page->details)->name); ?>"
                                                       data-link="<?php echo e($page->custom_link); ?>" data-pageid="<?php echo e($page->id); ?>">
                                                        <i class="bi bi-pencil-square dropdown-item-icon"></i>
                                                        Edit
                                                    </a>
                                                    <a class="dropdown-item deleteBtn" href="javascript:void(0)"
                                                       data-bs-toggle="modal" data-bs-target="#deleteModal"
                                                       data-route="<?php echo e(route('admin.delete.custom.link', $page->id)); ?>">
                                                        <i class="bi bi-trash dropdown-item-icon"></i> Delete
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <input type="hidden" name="menu_item[]"
                                           value="<?php echo e($page->name); ?>">
                                    <div class="js-sortable list-group nested-list d-none"
                                         data-hs-sortable-options='{
                                        "animation": 150,
                                        "group": "MenuSorting"
                                     }'>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title h4"><?php echo app('translator')->get('Manage Menu'); ?></h2>
                    </div>
                    <div class="card-body bg-soft-primary">
                        <form action="<?php echo e(route('admin.header.menu.item.store')); ?>" method="post" id="header-form">
                            <?php echo csrf_field(); ?>
                            <div class="js-sortable list-group manage-menu-drop"
                                 data-hs-sortable-options='{
                                  "animation": 150,
                                  "group": "MenuSorting",
                                  "fallbackOnBody": true
                                }'>
                                <?php if($headerMenus->menu_items): ?>
                                    <?php $__currentLoopData = $headerMenus->menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="list-group-item mb-2" draggable="false" style="">
                                            <div class="d-flex justify-content-between drop-content">
                                                <span><?php echo e(getPageName(is_numeric($key) ? $value : $key)); ?></span>
                                                <i class="fa-light fa-xmark text-danger remove-icon"></i>
                                            </div>
                                            <input type="hidden" value="<?php echo e(is_numeric($key) ? $value : $key); ?>"
                                                   name="menu_item[<?php echo e(is_numeric($key) ? $value : $key); ?>]">
                                            <div class="js-sortable list-group nested-list" data-hs-sortable-options='{
                                                 "animation": 150,
                                                 "group": "MenuSorting"
                                            }'>
                                                <?php if(is_array($value)): ?>
                                                    <?php echo $__env->make('admin.frontend_management.components.header_menu', ['menuArray' => $value], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                            <button type="button"
                                    class="btn btn-primary header-form-btn w-100"><?php echo app('translator')->get('Save Changes'); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-lg-5" id="manage-menu">
            <h3 class="ms-1"><?php echo app('translator')->get("Manage Menu For Footer"); ?></h3>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title h4"><?php echo app('translator')->get('Pages'); ?></h2>
                    </div>
                    <div class="card-body bg-soft-secondary">
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="js-sortable sortablejs-custom list-group manage-menu-drop-footer"
                                         data-hs-sortable-options='{
                                           "animation": 150,
                                           "group": "listGroup"
                                         }'>
                                        <div
                                            class="list-group-item mb-2 d-flex justify-content-between align-items-center">
                                            <span><?php echo app('translator')->get(ucwords(optional($page->details)->name ?? $page->name)); ?></span>
                                            <i class="fa-light"></i>
                                            <?php if($page->type == 3): ?>
                                                <div class="dropdown">
                                                    <button type="button"
                                                            class="btn btn-ghost-secondary btn-icon btn-sm rounded-circle"
                                                            id="contentActivityStreamDropdown" data-bs-toggle="dropdown"
                                                            aria-expanded="false">
                                                        <i class="bi-three-dots-vertical"></i>
                                                    </button>

                                                    <div class="dropdown-menu dropdown-menu-end mt-1"
                                                         aria-labelledby="contentActivityStreamDropdown" style="">
                                                        <a class="dropdown-item edit_custom_btn" data-bs-toggle="modal"
                                                           data-bs-target="#editCustomLinkModal"
                                                           data-route="<?php echo e(route("admin.update.custom.link", $page->id)); ?>"
                                                           data-name="<?php echo e(optional($page->details)->name); ?>"
                                                           data-link="<?php echo e($page->custom_link); ?>" data-pageid="<?php echo e($page->id); ?>">
                                                            <i class="bi bi-pencil-square dropdown-item-icon"></i>
                                                            Edit
                                                        </a>
                                                        <a class="dropdown-item deleteBtn" href="javascript:void(0)"
                                                           data-bs-toggle="modal" data-bs-target="#deleteModal"
                                                           data-route="<?php echo e(route('admin.delete.custom.link', $page->id)); ?>">
                                                            <i class="bi bi-trash dropdown-item-icon"></i> Delete
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <input type="hidden" name="menu_item[]"
                                                   value="<?php echo e(strtolower($page->name)); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <form action="<?php echo e(route('admin.footer.menu.item.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                        <div class="card" id="usefulLInk">
                            <div class="card-header">
                                <h2 class="card-title h4">
                                    <?php echo app('translator')->get('Useful Links'); ?>
                                </h2>
                            </div>
                            <div class="card-body bg-soft-primary">
                                <div class="col-md-12">
                                    <div class="js-sortable sortablejs-custom list-group useful-link"
                                         data-hs-sortable-options='{
                                                   "animation": 150,
                                                   "group": "listGroup"
                                                 }'>
                                        <?php if($footerMenus->menu_items): ?>
                                            <?php $__currentLoopData = $footerMenus->menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $footerMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($key == "useful_link"): ?>
                                                    <?php $__currentLoopData = $footerMenu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div
                                                            class="list-group-item mb-2 d-flex justify-content-between">
                                                            <span><?php echo app('translator')->get(getPageName($menu)); ?></span>
                                                            <i class="fa-light fa-xmark text-danger remove-icon-footer"></i>
                                                            <input type="hidden" name="menu_item[useful_link][]"
                                                                   value="<?php echo e($menu); ?>">
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mt-4" id="supportLInk">
                            <div class="card-header">
                                <h2 class="card-title h4">
                                    <?php echo app('translator')->get('Support Link'); ?>
                                </h2>
                            </div>
                            <div class="card-body bg-soft-primary">
                                <div class="js-sortable sortablejs-custom list-group support-link"
                                     data-hs-sortable-options='{
                                       "animation": 150,
                                       "group": "listGroup"
                                     }'>
                                    <?php if($footerMenus->menu_items): ?>
                                        <?php $__currentLoopData = $footerMenus->menu_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $footerMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($key == "support_link"): ?>
                                                <?php $__currentLoopData = $footerMenu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div
                                                        class="list-group-item mb-2 d-flex justify-content-between">
                                                        <span><?php echo app('translator')->get(getPageName($menu)); ?></span>
                                                        <i class="fa-light fa-xmark text-danger remove-icon-footer"></i>
                                                        <input type="hidden" name="menu_item[support_link][]"
                                                               value="<?php echo e($menu); ?>">
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 mt-3">
                            <button type="submit" class="btn btn-primary w-100"><?php echo app('translator')->get('Save Changes'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Create a Custom link  Modal -->
    <div class="modal fade" id="addCustomLinkModal" data-bs-backdrop="static" tabindex="-1"
         aria-labelledby="addCustomLinkModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="addCustomLinkModalLabel"><i class="bi bi-box-arrow-up-right"></i> Custom
                        Links</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route("admin.add.custom.link")); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-4">
                            <input type="text" class="form-control" id="linkText" name="link_text"
                                   placeholder="Button Name" autocomplete="off"
                                   aria-label="Button Name">

                            <?php $__errorArgs = ["link_text"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-2">
                            <input type="text" class="form-control" id="link" name="link" placeholder="https://" autocomplete="off" aria-label="https://">

                            <?php $__errorArgs = ["link"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Links</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Create a Custom link Modal -->


    <!-- Edit a Custom Link Modal -->
    <div class="modal fade" id="editCustomLinkModal" data-bs-backdrop="static" tabindex="-1"
         aria-labelledby="editCustomLinkModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="editCustomLinkModalLabel"><i class="bi bi-box-arrow-up-right"></i>
                        Custom
                        Links</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>


                <div class="modal-body">
                    <div class="edit-section-tab">
                        <ul class="nav nav-segment mb-2" role="tablist">
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item edit-nav-item" data-language="<?php echo e($language->id); ?>">
                                    <a class="nav-link <?php $__errorArgs = ['errActive'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php if($language->id == $message): ?> active <?php endif; ?> <?php else: ?> <?php if($loop->first): ?> active <?php endif; ?>  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="nav-one-eg1-tab"
                                       href="#nav-one-<?php echo e($key); ?>"
                                       data-bs-toggle="pill"
                                       data-bs-target="#nav-one-<?php echo e($key); ?>"
                                       role="tab" aria-controls="nav-one-<?php echo e($key); ?>"
                                       aria-selected="<?php $__errorArgs = ['errActive'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php if($language->id == $message): ?> true <?php else: ?> false <?php endif; ?> <?php else: ?> <?php if($loop->first): ?> true <?php else: ?> false <?php endif; ?>  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <?php echo app('translator')->get($language->name); ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="tab-pane fade <?php $__errorArgs = ['errActive'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php if($language->id == $message): ?> show active <?php endif; ?> <?php else: ?> <?php if($loop->first): ?> show active <?php endif; ?>  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="nav-one-<?php echo e($key); ?>"
                                role="tabpanel" aria-labelledby="nav-one-<?php echo e($key); ?>-tab">
                                <div class="row justify-content-lg-center">
                                    <form action="" method="post" class="editSetRoute"
                                          enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="language_id" value="<?php echo e($language->id); ?>">
                                        <div class="col-lg-12">
                                            <div class="mb-4">
                                                <input type="text" class="form-control editLinkText"
                                                       name="link_text[<?php echo e($language->id); ?>]"
                                                       placeholder="Link Text"
                                                       value="<?php echo e(old('link_text'.'.'.$language->id)); ?>"
                                                       aria-label="Link Text">
                                                <?php $__errorArgs = ['link_text'.'.'.$language->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="mb-2">
                                                <input type="text" class="form-control editLink"
                                                       name="link[<?php echo e($language->id); ?>]"
                                                       placeholder="https://"
                                                       value="<?php echo e(old('link'.'.'.$language->id)); ?>"
                                                       aria-label="https://">
                                                <?php $__errorArgs = ['link'.'.'.$language->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="d-flex justify-content-end align-items-center mt-3">
                                                <button type="button" class="btn btn-white me-2"
                                                        data-bs-dismiss="modal">Close
                                                </button>
                                                <button type="submit"
                                                        class="btn btn-primary"><?php echo app('translator')->get('Edit Link'); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Edit Custom Link Modal -->

    <!-- Delete Custom link Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
         data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="accountAddCardModalLabel"><i
                            class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="post" class="setRoute">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('delete'); ?>
                    <div class="modal-body">
                        <?php echo app('translator')->get('Do you want to delete this custom link data?'); ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get("Close"); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Confirm"); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Delete Custom link Modal -->

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/sortable.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        'use strict';

        <?php $__errorArgs = ['errorMessage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        let addCustomLinkModal = new bootstrap.Modal(document.getElementById("addCustomLinkModal"), {});
        document.onreadystatechange = function () {
            addCustomLinkModal.show();
        };
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        <?php $__errorArgs = ['errActive'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        let editCustomLinkModal = new bootstrap.Modal(document.getElementById("editCustomLinkModal"), {});
        document.onreadystatechange = function () {
            editCustomLinkModal.show();
        };
        let pageId = sessionStorage.getItem("pageid");
        $('.edit-nav-item').attr('data-pageid', pageId);
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        $(document).on('click', '.edit_custom_btn', function () {
            let url = $(this).data('route');
            $('.editSetRoute').attr('action', url);
        })

        $(document).on('click', '.edit_custom_btn', function () {
            let pageId = $(this).data('pageid');
            sessionStorage.setItem("pageid", pageId);
            $('.edit-nav-item').attr('data-pageid', pageId);
            $('.editLinkText').val($(this).data('name'));
            $('.editLink').val($(this).data('link'));
        })

        $(document).on('click', '.edit-nav-item', function () {
            const languageId = $(this).data('language');
            const pageId = $(this).data('pageid');

            $.ajax({
                url: '<?php echo e(route('admin.get.custom.link')); ?>',
                type: 'GET',
                data: {
                    pageId: pageId,
                    languageId: languageId
                },
                success: function (response) {
                    $('.editLinkText').val(response.name);
                    $('.editLink').val(response.custom_link);
                },
                error: function (xhr, status, error) {
                    // Handle errors
                }
            });
        })

        $(document).on('click', '.deleteBtn', function () {
            let url = $(this).data('route');
            $('.setRoute').attr('action', url);
        })

        $(document).on('change', '.drop-pages, .manage-menu-drop', function (event, ui) {
            $('.manage-menu-drop').find('.fa-light').addClass('fa-xmark text-danger remove-icon');
            $('.nested-list').removeClass('d-none');
            $('.manage-menu-drop').find('.dropdown').addClass('d-none');
        });

        $(document).on('click', '.header-form-btn', function (e) {
            var $manageMenuDrop = $('.manage-menu-drop');
            updateInputNames($manageMenuDrop);
            $('#header-form').submit();
        });

        function updateInputNames($list) {
            $list.find('.list-group-item').each(function () {
                var $input = $(this).find('input');
                var itemName = $input.val();
                var parentNames = getParentNames($(this));

                var $nestedList = $(this).find('.nested-list').find('.list-group-item');
                if ($nestedList.length <= 3) {
                    if ($nestedList.length <= 0) {
                        var name = 'menu_item' + (parentNames.length > 0 ? '[' + parentNames.join('][') + '][]' : '[]');
                        $input.attr('name', name);
                    } else {
                        $input.removeAttr('name');
                    }
                }
                if ($nestedList.length)
                    updateInputNames($nestedList);

            });
        }

        function getParentNames($item) {
            var parentNames = [];
            $item.parentsUntil('.manage-menu-drop', '.list-group-item').each(function () {
                parentNames.unshift($(this).find('input').val());
            });
            return parentNames;
        }


        $(document).on('change', '.manage-menu-drop-footer', function () {
            $('.manage-menu-drop-footer').find('button').addClass('d-none');
            let $nestedUsefulLink = $('.useful-link')
            $nestedUsefulLink.find('.fa-light').addClass('fa-xmark text-danger remove-icon');
            let $nestedElementsUseFul = $nestedUsefulLink.find('.list-group-item input');
            $nestedElementsUseFul.each(function () {
                let newName = "menu_item[useful_link][]";
                $(this).attr('name', newName);
            });

            let $nestedListSupport = $('.support-link')
            $nestedListSupport.find('.fa-light').addClass('fa-xmark text-danger remove-icon');
            $nestedListSupport.find('.fa-light').addClass('fa-xmark text-danger remove-icon');
            let $nestedElementsSupport = $nestedListSupport.find('.list-group-item input');
            $nestedElementsSupport.each(function () {
                let newName = "menu_item[support_link][]";
                $(this).attr('name', newName);
            });
        });

        $(document).on('click', ".remove-icon", function () {
            $(this).parent('.drop-content').parent('.list-group-item').remove();
        });

        $(document).on('click', ".remove-icon-footer", function () {
            $(this).parent('.list-group-item').remove();
        });

        (function () {
            HSCore.components.HSSortable.init('.js-sortable')
        })();

    </script>
<?php $__env->stopPush(); ?>






<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/frontend_management/manage-menu.blade.php ENDPATH**/ ?>