<?php use Illuminate\Support\Str; ?>

<?php $__env->startSection('title',trans('Package Searchs')); ?>
<?php $__env->startSection('content'); ?>
    <section class="amazing-tour-section section-padding">
        <div class="container">
            <div class="amazing-tour-wrapper">
                <div class="d-flex justify-content-end mb-3 d-block d-lg-none">
                    <button class="theme-btn smallMenuButton" id="toggleSidebarBtn">
                        <i class="fas fa-list"></i> <?php echo app('translator')->get('Search'); ?>
                    </button>
                </div>

                <div class="row g-4">
                    <div class="col-xl-3 col-lg-4">
                        <div class="tour-sidebar-area sticky-style d-none d-lg-block" id="tourSidebar">
                            <div class="tour-destination-sidebar">
                                <div class="booking-list-area">
                                    <form action="<?php echo e(route('package')); ?>" method="GET">
                                        <div class="booking-list d-flex align-items-start">
                                            <div class="icon me-1">
                                                <img src="<?php echo e(asset(template(true).'img/search.png')); ?>" alt="img">
                                            </div>
                                            <div class="content w-100">
                                                <h5 class="mt-2"><?php echo app('translator')->get('Search'); ?></h5>

                                                <div class="position-relative mt-2">
                                                    <input
                                                        type="text"
                                                        class="form-control pe-5"
                                                        name="search"
                                                        value="<?php echo e(old('search', request()->search)); ?>"
                                                        placeholder="<?php echo app('translator')->get('Search here'); ?>"
                                                    >
                                                    <button
                                                        type="submit"
                                                        class="btn position-absolute end-0 top-50 translate-middle-y me-2 p-0 border-0 bg-transparent"
                                                        style="z-index: 10;"
                                                    >
                                                        <i class="far fa-search"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                    <form id="filter-form">
                                        <div class="booking-list">
                                            <div class="icon">
                                                <img src="<?php echo e(asset(template(true).'img/location.png')); ?>" alt="img">
                                            </div>
                                            <div class="content">
                                                <h5><?php echo app('translator')->get('Destination'); ?></h5>
                                                <div class="form-clt">
                                                    <div class="form">
                                                        <select class="single-select w-100" name="destination">
                                                            <option value=""><?php echo app('translator')->get('Select Destination'); ?></option>
                                                            <?php $__currentLoopData = $destinations ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($destination->slug); ?>" <?php echo e((request()->destination == $destination->slug) ? 'selected' : ''); ?>><?php echo e($destination->title); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="booking-list">
                                            <div class="icon">
                                                <img src="<?php echo e(asset(template(true).'img/category.png')); ?>" alt="img">
                                            </div>
                                            <div class="content">
                                                <h5><?php echo app('translator')->get('Category'); ?></h5>
                                                <div class="form-clt">
                                                    <div class="form">
                                                        <select class="single-select w-100" name="category">
                                                            <option value=""><?php echo app('translator')->get('Select Category'); ?></option>
                                                            <?php $__currentLoopData = $categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e(slug($category->name)); ?>" <?php echo e((request()->category == slug($category->name)) ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="booking-list">
                                            <div class="icon">
                                                <img src="<?php echo e(asset(template(true).'img/country.png')); ?>" alt="img">
                                            </div>
                                            <div class="content">
                                                <h5><?php echo app('translator')->get('Country'); ?></h5>
                                                <div class="form-clt countryDropDown">
                                                    <div class="form">
                                                        <select class="single-select w-100" name="country">
                                                            <option value=""><?php echo app('translator')->get('Select Country'); ?></option>
                                                            <?php $__currentLoopData = $countries ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($country->iso2); ?>" <?php echo e(($country->iso2 == request()->country) ? 'selected' : ''); ?>><?php echo e($country->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tour-sidebar-widget">
                                            <div class="wid-title">
                                                <h3><?php echo app('translator')->get('Filter by Price'); ?></h3>
                                            </div>
                                            <div class="price-range-wrapper">
                                                <div class="slider-container">
                                                    <input type="range" id="min-slider" class="slider"
                                                           min="<?php echo e($rangeMin); ?>"
                                                           max="<?php echo e($rangeMax); ?>"
                                                           value="<?php echo e($min); ?>">
                                                    <input type="range" id="max-slider" class="slider"
                                                           min="<?php echo e($rangeMin); ?>"
                                                           max="<?php echo e($rangeMax); ?>"
                                                           value="<?php echo e($max); ?>">
                                                </div>
                                                <div class="price-text pt-4 d-flex gap-3">
                                                    <label for="amount"><?php echo app('translator')->get('Price:'); ?></label>
                                                    <input type="text" id="amount" readonly style="border:0;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tour-sidebar-widget">
                                            <div class="wid-title">
                                                <h3><?php echo app('translator')->get('Amenities'); ?></h3>
                                            </div>
                                            <div class="checkbox-items">
                                                <?php $__currentLoopData = $amenities ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <label class="checkbox-single">
                                                        <span class="d-flex gap-xl-3 gap-2 align-items-center">
                                                            <span class="checkbox-area d-center">
                                                                <input type="checkbox" name="amenities[]" value="<?php echo e($amenity->id); ?>">
                                                                <span class="checkmark d-center"></span>
                                                            </span>
                                                            <span class="text-color">
                                                                <?php echo e($amenity->title); ?>

                                                            </span>
                                                        </span>
                                                    </label>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-9 col-lg-8">
                        <div class="row g-4 showItems">
                            <?php
                                $params = [
                                    'date' => request()->date,
                                    'slot' => request()->slot,
                                ];

                                $query = http_build_query(array_filter($params));
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pack): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-xl-4 col-lg-6 col-md-6">
                                    <div class="amazing-tour-items mt-0">
                                        <div class="thumb">
                                            <div class="post-box">
                                                <h4><?php echo e(discountPrice($pack)); ?></h4>
                                                <span>/ <?php echo app('translator')->get('person'); ?></span>
                                            </div>
                                            <img src="<?php echo e(getFile($pack->thumb_driver, $pack->thumb)); ?>" alt="<?php echo e($pack->title ?? ''); ?>">
                                            <div class="list-items">
                                                <?php if($pack->is_featured == 1): ?>
                                                    <h6><?php echo app('translator')->get('FEATURED'); ?></h6>
                                                <?php endif; ?>

                                                <ul class="popup-icon">
                                                    <?php if(isset($pack->video)): ?>
                                                        <li>
                                                            <a href="<?php echo e($pack->video ?? '#'); ?>" class="video-buttton video-popup">
                                                                <i class="far fa-video"></i>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>

                                                    <li>
                                                        <?php
                                                            $images = [];
                                                            foreach ($pack->media as $packImage) {
                                                                $images[] = getFile($packImage->driver, $packImage->image);
                                                            }
                                                        ?>
                                                        <a href="#" class="package_img_popup" data-images='<?php echo json_encode($images, 15, 512) ?>'>
                                                            <i class="far fa-camera"></i>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="content">
                                            <div class="package-content-title">
                                                <h4>
                                                    <a href="<?php echo e(route('package.details', ['slug' => $pack->slug]). ($query ? '?' . $query : '')); ?>"><?php echo e(str_replace('&amp;', '&', $pack->title ?? '')); ?></a>
                                                </h4>
                                                <?php
                                                    $fullLocation = $pack->cityTake?->name . ', ' . $pack->stateTake?->name . ', ' . $pack->countryTake?->name;
                                                    $shortLocation = Str::limit($fullLocation, 40);
                                                ?>
                                                <span class="location-icon" title="<?php echo e($fullLocation); ?>">
                                                    <i class="far fa-map-marker-alt"></i>
                                                    <?php echo e($shortLocation); ?>

                                                </span>
                                            </div>
                                            <a href="<?php echo e(route('package.details', ['slug' => $pack->slug]). ($query ? '?' . $query : '')); ?>" class="theme-btn">
                                                <span><?php echo app('translator')->get('Book Now'); ?></span> <i class="far fa-long-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php echo $__env->make('empty', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                        </div>
                        <?php echo e($packages->appends(request()->query())->links(template().'partials.pagination')); ?>


                        <div class="d-flex justify-content-center mt-5 ajaxLoadMore d-none">
                            <button class="theme-btn load-more-btn d-flex align-items-center justify-content-center" data-segment="1">
                                <span class="btn-text"><?php echo app('translator')->get('Load More'); ?></span>
                                <span class="spinner-border spinner-border-sm text-light ms-2 d-none" role="status" aria-hidden="true"></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .searchInput::placeholder{
            font-weight: 400;
        }

        .form-control {
            width: 100% !important;
            outline: none !important;
            border-radius: 4px !important;
            border: 1px solid rgba(35, 28, 37, 0.1) !important;
            background: var(--white) !important;
            color: var(--text) !important;
            padding: 10px 13px !important;
            font-weight: 500 !important;
            text-transform: capitalize !important;
        }
        .countryDropDown .nice-select .list{
            max-height: 350px !important;
            height: auto !important;
            overflow: auto !important;
        }
        .smallMenuButton i{
            width: 28px;
            height: 28px;
            line-height: 28px;
            margin: 0 10px 0 0;
            background: transparent;
            color: #fff;
        }
        .smallMenuButton{
            margin-bottom: 10px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function () {
            $('#toggleSidebarBtn').on('click', function () {
                const $sidebar = $('#tourSidebar');

                if (window.innerWidth < 992) {
                    $sidebar.toggleClass('d-none');
                }
            });
        });
        document.addEventListener("DOMContentLoaded", function () {
            const minSlider = document.getElementById("min-slider");
            const maxSlider = document.getElementById("max-slider");
            const amount = document.getElementById("amount");

            function updateAmount() {
                let minValue = parseInt(minSlider.value, 10);
                let maxValue = parseInt(maxSlider.value, 10);

                if (minValue > maxValue) {
                    minValue = maxValue;
                    minSlider.value = minValue;
                }

                amount.value = "$" + minValue + " - $" + maxValue;

                const minPercent = ((minValue - minSlider.min) / (minSlider.max - minSlider.min)) * 100;
                const maxPercent = ((maxValue - maxSlider.min) / (maxSlider.max - maxSlider.min)) * 100;

                const bg = `linear-gradient(to right, #000 ${minPercent}%, #4D40CA ${minPercent}%, #4D40CA ${maxPercent}%, #000 ${maxPercent}%)`;

                minSlider.style.background = bg;
                maxSlider.style.background = bg;
            }

            if (amount && minSlider && maxSlider) {
                updateAmount();
                minSlider.addEventListener("input", updateAmount);
                maxSlider.addEventListener("input", updateAmount);
            }
        });

        $(document).ready(function () {
            $(document).on('click', '.package_img_popup', function (e) {
                e.preventDefault();
                var images = $(this).data('images');

                if (!images || !images.length) return;

                var items = images.map(function (url) {
                    return { src: url };
                });

                $.magnificPopup.open({
                    items: items,
                    type: 'image',
                    gallery: {
                        enabled: true
                    }
                });
            });

            $('.ajaxLoadMore').addClass('d-none');
            let currentSegment = 1;

            function runAjaxSearch() {
                currentSegment = 1;

                let destination = $('select[name="destination"]').val();
                let country = $('select[name="country"]').val();
                let min_price = $('#min-slider').val();
                let max_price = $('#max-slider').val();

                let amenities = [];
                $('input[name="amenities[]"]:checked').each(function () {
                    amenities.push($(this).val());
                });

                $.ajax({
                    url: '<?php echo e(route('package.search')); ?>',
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        destination: destination,
                        country: country,
                        min_price: min_price,
                        max_price: max_price,
                        amenities: amenities,
                        segment: currentSegment
                    },
                    success: function (response) {
                        $('.showItems').html('');
                        $('#pagination').addClass('d-none');
                        $('.ajaxLoadMore').removeClass('d-none');
                        if (response.packages.length === 0) {
                            $('.showItems').html(`
                                <section class="no-data-section section-padding text-center">
                                    <div class="container">
                                        <div class="row justify-content-center">
                                            <div class="col-lg-6">
                                                <div class="no-data-content">
                                                    <div class="no-data-image mb-4">
                                                        <img src="<?php echo e(asset('assets/global/img/oc-error.svg')); ?>" alt="No Data" class="img-fluid noDataImage">
                                                    </div>
                                                    <h2 class="no-data-title mb-3"><?php echo app('translator')->get('No Data Found'); ?></h2>
                                                    <p class="no-data-text mb-4"><?php echo app('translator')->get("We couldn't find what you're looking for. Please try again later or modify your search."); ?></p>
                                                    <a href="<?php echo e(url()->previous()); ?>" class="btn btn-primary noDataBtn"><?php echo app('translator')->get("Go Back"); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </section>
                                `);
                            $('.load-more-btn').addClass('d-none');
                            return;
                        }
                        let $btn = $('.load-more-btn');
                        let $spinner = $btn.find('.spinner-border');
                        let $btnText = $btn.find('.btn-text');

                        $btn.prop('disabled', false);
                        $spinner.addClass('d-none');
                        $btnText.text('Load More');

                        appendPackages(response.packages);

                        if (response.has_more) {
                            $('.load-more-btn').removeClass('d-none').data('segment', response.next_segment);
                        } else {
                            $('.load-more-btn').addClass('d-none');
                        }
                    }
                });
            }

            function loadMore() {
                let $btn = $('.load-more-btn');
                let $spinner = $btn.find('.spinner-border');
                let $btnText = $btn.find('.btn-text');

                let segment = $btn.data('segment');
                let destination = $('select[name="destination"]').val();
                let sort_by = $('select[name="sort_by"]').val();

                $btn.prop('disabled', true);
                $spinner.removeClass('d-none');
                $btnText.text('Loading...');

                $.ajax({
                    url: '<?php echo e(route('package.search')); ?>',
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        destination: destination,
                        sort_by: sort_by,
                        segment: segment
                    },
                    success: function (response) {
                        appendPackages(response.packages);

                        if (response.has_more) {
                            $btn.data('segment', response.next_segment).prop('disabled', false);
                            $btnText.text('Load More');
                            $spinner.addClass('d-none');
                        } else {
                            $btn.addClass('d-none');
                        }
                    },
                    error: function () {
                        $btn.prop('disabled', false);
                        $btnText.text('Load More');
                        $spinner.addClass('d-none');
                    }
                });
            }



            function appendPackages(packages) {
                console.log(packages)
                packages.forEach(function (item) {
                    let html = `
                        <div class="col-xl-4 col-lg-6 col-md-6">
                            <div class="amazing-tour-items mt-0">
                                <div class="thumb">
                                    <div class="post-box">
                                        <h4>${item.formatedPrice}</h4>
                                        <span>/ person</span>
                                    </div>
                                    <img src="${item.imageUrl}" alt="img">
                                    <div class="list-items">
                                        ${item.is_featured == 1 ? `<h6>FEATURED</h6>` : ''}
                                        <ul class="popup-icon">
                                            ${item.video ? `
                                                <li>
                                                    <a href="${item.video}" class="video-buttton video-popup">
                                                        <i class="far fa-video"></i>
                                                    </a>
                                                </li>` : ''}
                                            <li>
                                                <a href="#" class="package_img_popup" data-images='${JSON.stringify(item.imagesUrl)}'>
                                                    <i class="far fa-camera"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="content">
                                    <h4>
                                        <a href="${item.detailsUrl}">${item.title}</a>
                                    </h4>
                                    <span class="location-icon" title="${item.address ?? 'Location not available'}">
                                        <i class="far fa-map-marker-alt"></i>
                                        ${ (item.address && item.address.length > 50)
                                                            ? item.address.substring(0, 50) + '...'
                                                            : (item.address ?? 'Location not available') }
                                    </span>
                                    <a href="${item.detailsUrl}" class="theme-btn">
                                        <span><?php echo app('translator')->get('Book Now'); ?></span> <i class="far fa-long-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>`;
                    $('.showItems').append(html);
                });
            }

            $('#filter-form').on('change', 'select, input[type=checkbox], input[type=range]', runAjaxSearch);

            let debounceTimer;
            $('#filter-form').on('input', 'input[type=range]', function () {
                clearTimeout(debounceTimer);
                debounceTimer = setTimeout(runAjaxSearch, 300);
            });

            $('.load-more-btn').on('click', loadMore);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(template() . 'layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/frontend/package/listThree.blade.php ENDPATH**/ ?>