<div class="page-header">
    <div class="row align-items-center">
        <div class="col-sm mb-2 mb-sm-0">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb breadcrumb-no-gutter">
                    <li class="breadcrumb-item">
                        <a class="breadcrumb-link" href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get("Dashboard"); ?></a>
                    </li>
                    <?php if(isset($menu)): ?>
                        <li class="breadcrumb-item active" aria-current="page">
                            <?php echo app('translator')->get($menu); ?>
                        </li>
                    <?php endif; ?>
                    <?php if(isset($submenu)): ?>
                        <li class="breadcrumb-item active" aria-current="page">
                            <?php echo app('translator')->get($submenu); ?>
                        </li>
                    <?php endif; ?>
                </ol>
            </nav>
            <h1 class="page-header-title">
                <?php if(isset($pagetitle)): ?>
                    <?php echo app('translator')->get($pagetitle); ?>
                <?php else: ?>
                    <?php if (! empty(trim($__env->yieldContent('page_title')))): ?>
                        <?php echo $__env->yieldContent('page_title'); ?>
                    <?php else: ?>
                        <?php echo $__env->yieldContent('title'); ?>
                    <?php endif; ?>
                <?php endif; ?>
            </h1>

            <?php if(isset($exportImport)): ?>
                <div class="mt-2">
                    <a class="text-body me-3" href="javascript:void(0)" data-bs-toggle="modal"
                       data-bs-target="#exportProductsModal">
                        <i class="bi-download me-1"></i> <?php echo app('translator')->get('Export'); ?>
                    </a>
                    <a class="text-body" href="javascript:void(0)" data-bs-toggle="modal"
                       data-bs-target="#importProductsModal">
                        <i class="bi-upload me-1"></i> <?php echo app('translator')->get('Import'); ?>
                    </a>
                </div>
            <?php endif; ?>

        </div>

        <div class="col-sm-auto">
            <?php if($statBtn ?? false): ?>
                <a class="btn btn-primary btn-sm statBtn" href="javascript:;" id="toggleStats">
                    <i class="bi-receipt"></i> <?php echo app('translator')->get('See Stats'); ?>
                </a>
                <?php $__env->startPush('script'); ?>
                    <script>
                        document.addEventListener('DOMContentLoaded', function () {
                            let button = document.getElementById('toggleStats');
                            let statsSection = document.getElementById('statsSection');

                            if (localStorage.getItem('statsVisible') === 'true') {
                                statsSection.classList.remove('d-none');
                                button.innerHTML = `<i class="bi-receipt"></i> <?php echo e(__('Hide Stats')); ?>`;
                            }

                            button.addEventListener('click', function () {
                                statsSection.classList.toggle('d-none');
                                let isVisible = !statsSection.classList.contains('d-none');
                                localStorage.setItem('statsVisible', isVisible);
                                button.innerHTML = isVisible
                                    ? `<i class="bi-receipt"></i> <?php echo e(__('Hide Stats')); ?>`
                                    : `<i class="bi-receipt"></i> <?php echo e(__('See Stats')); ?>`;
                            });
                        });

                    </script>
                <?php $__env->stopPush(); ?>
            <?php endif; ?>
        </div>
    </div>
</div>




<?php /**PATH /home/ygnbmjdo/safarix/resources/views/components/page-header.blade.php ENDPATH**/ ?>