
<?php $__env->startSection('page_title',__('Logo Setting')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Settings'); ?></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Logo Settings'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Logo Settings'); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-3">
                <?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>

            <div class="col-lg-7">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header">
                            <h2 class="card-title h4"><?php echo app('translator')->get('Logo, Favicon & Breadcrumb Settings'); ?></h2>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.logo.update')); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <label class="col-form-label"><?php echo app('translator')->get('Website Logo'); ?></label>
                                        <label class="form-check form-check-dashed" for="logoUploader">
                                            <img id="logoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->logo_driver, $basicControl->logo, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Logo"); ?>"
                                                 data-hs-theme-appearance="default">

                                            <img id="logoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->logo_driver, $basicControl->logo, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Logo"); ?>" data-hs-theme-appearance="dark">
                                            <span class="d-block mb-3"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach-logo form-check-input"
                                                   name="logo" id="logoUploader"
                                                   data-hs-file-attach-options='{
                                                      "textTarget": "#logoImg",
                                                      "mode": "image",
                                                      "targetAttr": "src",
                                                      "allowTypes": [".png", ".jpeg", ".jpg", ".svg"]
                                                   }'>
                                        </label>
                                        <?php $__errorArgs = ["logo"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="col-form-label"><?php echo app('translator')->get('Favicon'); ?></label>
                                        <label class="form-check form-check-dashed" for="faviconUploader">
                                            <img id="faviconImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Favicon"); ?>"
                                                 data-hs-theme-appearance="default">

                                            <img id="faviconImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Favicon"); ?>" data-hs-theme-appearance="dark">
                                            <span class="d-block mb-3"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach-favicon form-check-input"
                                                   name="favicon" id="faviconUploader"
                                                   data-hs-file-attach-options='{
                                                      "textTarget": "#faviconImg",
                                                      "mode": "image",
                                                      "targetAttr": "src",
                                                      "allowTypes": [".png", ".jpeg", ".jpg", ".svg"]
                                                   }'>
                                        </label>
                                        <?php $__errorArgs = ["favicon"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="col-form-label"><?php echo app('translator')->get('Admin Default Logo'); ?></label>
                                        <label class="form-check form-check-dashed" for="adminLogoUploader">
                                            <img id="adminLogoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->admin_logo_driver, $basicControl->admin_logo, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Admin Logo"); ?>"
                                                 data-hs-theme-appearance="default">

                                            <img id="adminLogoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->admin_logo_driver, $basicControl->admin_logo, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Admin Logo"); ?>" data-hs-theme-appearance="dark">
                                            <span class="d-block mb-3"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach-admin-logo form-check-input"
                                                   name="admin_logo" id="adminLogoUploader"
                                                   data-hs-file-attach-options='{
                                                      "textTarget": "#adminLogoImg",
                                                      "mode": "image",
                                                      "targetAttr": "src",
                                                      "allowTypes": [".png", ".jpeg", ".jpg", ".svg"]
                                                   }'>
                                        </label>
                                        <?php $__errorArgs = ["admin_logo"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="col-form-label"><?php echo app('translator')->get('Admin Logo Dark Mode'); ?></label>
                                        <label class="form-check form-check-dashed adminDarkLogoUploader" for="adminDarkLogoUploader">
                                            <img id="adminDarkVersionLogo"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->admin_dark_mode_logo_driver, $basicControl->admin_dark_mode_logo, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Admin Dark Version Logo"); ?>"
                                                 data-hs-theme-appearance="default">

                                            <img id="adminDarkVersionLogo"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(getFile($basicControl->admin_dark_mode_logo_driver, $basicControl->admin_dark_mode_logo, true)); ?>"
                                                 alt="<?php echo app('translator')->get("Admin Dark Version Logo"); ?>" data-hs-theme-appearance="dark">
                                            <span class="d-block mb-3"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach-admin-dark-logo form-check-input"
                                                   name="admin_dark_mode_logo" id="adminDarkLogoUploader"
                                                   data-hs-file-attach-options='{
                                                      "textTarget": "#adminDarkVersionLogo",
                                                      "mode": "image",
                                                      "targetAttr": "src",
                                                      "allowTypes": [".png", ".jpeg", ".jpg", ".svg"]
                                                   }'>
                                        </label>
                                        <?php $__errorArgs = ["admin_dark_mode_logo"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-start mt-lg-5">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Save changes"); ?></button>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset("assets/admin/js/hs-file-attach.min.js")); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).ready(function () {

            new HSFileAttach('.js-file-attach-logo', {
                textTarget: "#logoImg"
            });
            new HSFileAttach('.js-file-attach-favicon', {
                textTarget: "#faviconImg"
            });
            new HSFileAttach('.js-file-attach-admin-logo', {
                textTarget: "#adminLogoImg"
            });

            new HSFileAttach('.js-file-attach-admin-dark-logo', {
                textTarget: "#adminDarkVersionLogo"
            });

        })
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/control_panel/logo.blade.php ENDPATH**/ ?>