
<?php $__env->startSection('page_title', __('KYC Verification')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)">
                                    <?php echo app('translator')->get('Dashboard'); ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('KYC'); ?></li>
                            <li class="breadcrumb-item active"
                                aria-current="page"><?php echo app('translator')->get($userKyc->kyc_type.' Information'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get($userKyc->kyc_type.' Information'); ?></h1>
                </div>
            </div>
        </div>


        <div class="row">
            <div class="col-lg-4">
                <div class="card mb-3 mb-lg-5">
                    <div class="card-header card-header-content-between">
                        <h4 class="card-header-title"><?php echo app('translator')->get("User Profile"); ?></h4>
                        <a class="btn btn-white btn-sm"
                           href="<?php echo e(route('admin.user.view.profile', optional($userKyc->user)->id)); ?>"><i
                                class="bi-eye me-1"></i> <?php echo app('translator')->get("View Profile"); ?></a>
                    </div>

                    <div class="card-body">
                        <ul class="list-unstyled list-py-2 text-dark mb-0">
                            <li class="pb-0"><span class="card-subtitle"><?php echo app('translator')->get("About"); ?></span></li>
                            <li>
                                <i class="bi-person dropdown-item-icon"></i> <?php echo app('translator')->get(optional($userKyc->user)->firstname . " " . optional($userKyc->user)->lastname); ?>
                            </li>
                            <li>
                                <i class="bi-briefcase dropdown-item-icon"></i> <?php echo app('translator')->get('@'.optional($userKyc->user)->username); ?>
                            </li>


                            <li class="pt-4 pb-0"><span class="card-subtitle"><?php echo app('translator')->get("Contacts"); ?></span></li>
                            <li><i class="bi-at dropdown-item-icon"></i> <?php echo app('translator')->get(optional($userKyc->user)->email); ?></li>
                            <li><i class="bi-phone dropdown-item-icon"></i> <?php echo app('translator')->get(optional($userKyc->user)->phone); ?></li>

                            <?php if(optional($userKyc->user)->country): ?>
                                <li class="pt-4 pb-0"><span class="card-subtitle"><?php echo app('translator')->get("Address"); ?></span></li>
                                <li class="fs-6 text-body">
                                    <i class="bi bi-geo-alt dropdown-item-icon"></i> <?php echo app('translator')->get(optional($userKyc->user)->country); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>
            </div>


            <div class="col-lg-8">
                <div class="card mb-3 mb-lg-5">
                    <div class="card-header card-header-content-between">
                        <h4 class="card-header-title"><?php echo app('translator')->get($userKyc->kyc_type.' Information'); ?></h4>
                        <?php if($userKyc->status == 0): ?>
                            <span class="badge bg-soft-warning text-warning">
                                    <span class="legend-indicator bg-warning"></span><?php echo app('translator')->get("Pending"); ?>
                                </span>
                        <?php elseif($userKyc->status == 1): ?>
                            <span class="badge bg-soft-success text-success">
                            <span class="legend-indicator bg-success"></span><?php echo app('translator')->get("Verified"); ?>
                            </span>
                        <?php elseif($userKyc->status == 2): ?>
                            <span class="badge bg-soft-danger text-danger">
                            <span class="legend-indicator bg-danger"></span><?php echo app('translator')->get("Rejected"); ?>
                            </span>
                        <?php endif; ?>
                    </div>

                    <?php if($userKyc->kyc_info): ?>
                        <div class="card-body">
                            <ul class="list-group list-group-flush list-group-no-gutters">
                                <?php $__currentLoopData = $userKyc->kyc_info; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($value->type == "text" || $value->type === "textarea" ||  $value->type == "number" || $value->type == "date"): ?>
                                        <li class="list-group-item">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h5><?php echo app('translator')->get(snake2Title($value->field_label)); ?></h5>
                                                <ul class="list-unstyled list-py-2 text-body">
                                                    <li><?php echo e($value->field_value); ?></li>
                                                </ul>
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($value->type == "file"): ?>
                                        <li class="list-group-item">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h5><?php echo app('translator')->get(snake2Title($value->field_name)); ?></h5>
                                                <ul class="list-unstyled list-py-2 text-body">
                                                    <li>
                                                        <a href="<?php echo e(getFile($value->field_driver,$value->field_value)); ?>"
                                                           target="_blank">
                                                            <img
                                                                src="<?php echo e(getFile($value->field_driver,$value->field_value)); ?>"
                                                                class="kycInfoImg">
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($userKyc->reason): ?>
                                        <li class="list-group-item">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h5><?php echo app('translator')->get("Rejected Reason"); ?></h5>
                                                <ul class="list-unstyled list-py-2 text-body">
                                                    <li>
                                                        <?php echo app('translator')->get($userKyc->reason); ?>
                                                    </li>
                                                </ul>
                                            </div>
                                        </li>
                                    <?php endif; ?>

                            </ul>
                            <?php if($userKyc->status == 0): ?>
                                <div class="d-flex justify-content-end gap-3 mt-2">
                                    <button type="button" class="btn btn-success approve-btn"
                                            data-value="1"
                                            data-message="<?php echo app('translator')->get("Do you want to approved this kyc information?"); ?>"
                                            data-bs-toggle="modal"
                                            data-bs-target="#kycStatusChangeModal"><?php echo app('translator')->get('Approved'); ?></button>
                                    <button type="button" class="btn btn-danger rejected-btn" data-bs-toggle="modal"
                                            data-message="<?php echo app('translator')->get("Do you want to rejected this kyc information?"); ?>"
                                            data-value="2"
                                            data-bs-target="#kycStatusChangeModal"><?php echo app('translator')->get('Rejected'); ?></button>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <?php if(count((array)$userKyc->kyc_info) == 0): ?>
                        <div class="card-body card-body-height text-center">
                            <img class="avatar avatar-xxl mb-3"
                                 src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                 alt="Image Description" data-hs-theme-appearance="default"/>
                            <img class="avatar avatar-xxl mb-3"
                                 src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                 alt="Image Description" data-hs-theme-appearance="dark"/>
                            <p class="card-text"><?php echo app('translator')->get('No data to show'); ?></p>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>

        <div class="modal fade" id="kycStatusChangeModal" tabindex="-1" role="dialog" data-bs-backdrop="static"
             aria-labelledby="kycStatusChangeModalLabel"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="statusModalLabel"><i
                                class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.kyc.action',$userKyc->id)); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <p class="message"></p>
                            <input type="hidden" name="status" id="status" value="">
                            <div class="reject_area mt-2">
                                <span class="mb-1"><?php echo app('translator')->get('Rejection Reason'); ?></span>
                                <textarea class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="rejected_area" placeholder="<?php echo app('translator')->get("Message"); ?>"><?php echo e(old('rejected_reason')); ?></textarea>
                                <?php $__errorArgs = ['rejected_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php if($userKyc->apply_for == 1): ?>
                                <div id="restrict-user-section" class="d-none">
                                    <li class="list-group-item mt-5">
                                        <div class="d-flex">
                                            <div class="flex-grow-1">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <h5 class="mb-0"><?php echo app('translator')->get('Restrict User'); ?></h5>
                                                        <span class="d-block fs-6 text-body"><?php echo app('translator')->get('Enable this option to prevent the user from submitting any vendor requests.'); ?></span>
                                                    </div>

                                                    <div class="col-auto">
                                                        <label class="row form-check form-switch mb-3" for="restrict_for_vendor_request">
                                                            <span class="col-4 col-sm-3 text-end">
                                                                <input type='hidden' value='0' name='restrict_for_vendor_request'>
                                                                <input
                                                                    class="form-check-input <?php $__errorArgs = ['restrict_for_vendor_request'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    type="checkbox"
                                                                    name="restrict_for_vendor_request"
                                                                    id="restrict_for_vendor_request"
                                                                    value="1" <?php echo e(($userKyc->user?->as_a_vendor_from == 1) ? 'checked' : ''); ?>>
                                                            </span>
                                                            <?php $__errorArgs = ['restrict_for_vendor_request'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </div>
                            <?php endif; ?>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).ready(function () {

            <?php $__errorArgs = ['rejectedMessage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            let kycStatusChangeModal = new bootstrap.Modal(document.getElementById("kycStatusChangeModal"), {});
            document.onreadystatechange = function () {
                kycStatusChangeModal.show();
            };
            $(".message").text("Do you want to rejected this kyc information?");
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

            $('.approve-btn, .rejected-btn').on('click', function () {
                let message = $(this).data('message');
                $(".message").text(message);
                $(".reject_area").toggle($(this).hasClass('rejected-btn'));
                $('#status').val($(this).data('value'));
            });

            $(document).on('click', '.rejected-btn', function () {
                $('#rejected_area').attr('name', 'rejected_reason');
            })

            HSCore.components.HSTomSelect.init('.js-select')
        });

        document.addEventListener("DOMContentLoaded", function () {
            const buttons = document.querySelectorAll(".approve-btn, .rejected-btn");
            const messageBox = document.querySelector(".message");
            const statusInput = document.getElementById("status");
            const restrictSection = document.getElementById("restrict-user-section");

            buttons.forEach(button => {
                button.addEventListener("click", function () {
                    const value = this.getAttribute("data-value");
                    const message = this.getAttribute("data-message");

                    messageBox.textContent = message;
                    statusInput.value = value;

                    if (restrictSection) {
                        if (value === "2") {
                            restrictSection.classList.remove("d-none");
                        } else {
                            restrictSection.classList.add("d-none");
                        }
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/kyc/view.blade.php ENDPATH**/ ?>