
<?php $__env->startSection('page_title', __('Payment Gateways')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="row justify-content-lg-center">
            <div class="col-lg-10">
                <div class="page-header custom-header">
                    <div class="row">
                        <div class="col-sm mb-2 mb-sm-0 d-flex align-items-center justify-content-between">
                            <div class="left">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb breadcrumb-no-gutter">
                                        <li class="breadcrumb-item"><a class="breadcrumb-link" href="javascript:void(0);"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Payment Gateways'); ?></li>
                                    </ol>
                                </nav>
                                <h1 class="page-header-title"><?php echo app('translator')->get('Payment Gateways'); ?></h1>
                            </div>
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('user.payment.gateway.manage')); ?>"><i class="bi-pencil pe-2"></i><?php echo app('translator')->get('Manage'); ?></a>
                        </div>
                    </div>
                </div>

                <div class="row row-cols-1 row-cols-sm-2 row-cols-xl-3 uGate">
                    <?php $__empty_1 = true; $__currentLoopData = $gateways ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col mb-3 mb-lg-5">
                            <div class="card h-100">
                                <div class="card-pinned">
                                    <div class="card-pinned-top-end">
                                        <div class="dropdown">
                                            <button type="button" class="btn btn-ghost-secondary btn-icon btn-sm rounded-circle" id="connectionsDropdown2" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="bi-three-dots-vertical"></i>
                                            </button>

                                            <div class="dropdown-menu dropdown-menu-sm dropdown-menu-end" aria-labelledby="connectionsDropdown2">
                                                <a class="dropdown-item" href="<?php echo e(route('user.payment.gateway.edit', $gateway->id)); ?>"><i class="bi-pencil-square pe-1"></i><?php echo app('translator')->get('Edit'); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body text-center gateway-card-image">
                                    <!-- Avatar -->
                                    <div class="avatar avatar-xl avatar-circle avatar-centered mb-3">
                                        <img class="avatar-img" src="<?php echo e(getFile($gateway->driver, $gateway->image)); ?>" alt="<?php echo e($gateway->name); ?>">
                                    </div>

                                    <h3 class="mb-1">
                                        <a class="text-dark"><?php echo e($gateway->name); ?></a>
                                    </h3>

                                    <?php if(isset($gateway->description)): ?>
                                        <div class="mb-3">
                                            <i class="bi-building me-1"></i>
                                            <span><?php echo e($gateway->description); ?></span>
                                        </div>
                                    <?php endif; ?>

                                    <ul class="list-inline mb-0 mt-2">
                                        <?php $__currentLoopData = $gateway->supported_currency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="list-inline-item">
                                                <a class="badge bg-soft-secondary text-secondary p-2">
                                                    <?php echo e($item); ?>

                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                                <div class="card-footer">
                                    <div class="row justify-content-between align-items-center">
                                        <div class="col-auto py-1">
                                            <p class="fs-6 text-body mb-0">
                                                <?php echo e(count($gateway->supported_currency)); ?> out of <?php echo e($gateway->countGatewayCurrency()); ?> <?php echo app('translator')->get('gateway currencies are active'); ?>
                                            </p>

                                        </div>

                                        <div class="col-auto py-1">
                                            <span class="badge bg-success">
                                                <i class="bi-check-circle me-1"></i> <?php echo app('translator')->get('Active'); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <section class="no-data-section section-padding text-center">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-lg-6">
                                        <div class="no-data-content">
                                            <div class="no-data-image mb-4">
                                                <img src="<?php echo e(asset('assets/global/img/oc-error.svg')); ?>" alt="No Data" class="img-fluid noDataImage">
                                            </div>
                                            <h2 class="no-data-title mb-3"><?php echo app('translator')->get('No Data Found'); ?></h2>
                                            <p class="no-data-text mb-4"><?php echo app('translator')->get("We couldn't find what you're looking for. Please try again later or modify your search."); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                        <style>
                            .noDataImage{
                                height: 250px !important;
                                width: 250px !important;
                            }
                        </style>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
    <style>
        .avatar-img{
            max-width: 100% !important;
            height: 88% !important;
        }
        .avatar-xl.avatar-circle .avatar-sm-status {
            bottom: 10px !important;
        }
        .uGate{
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
<?php $__env->stopPush(); ?>





<?php echo $__env->make(template().'layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/user/gateway/index.blade.php ENDPATH**/ ?>