
<?php $__env->startSection('page_title', __('KYC Setting')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)">
                                    <?php echo app('translator')->get('Dashboard'); ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('KYC Setting'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('KYC Setting'); ?></h1>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title m-0"><?php echo app('translator')->get('KYC Form'); ?></h4>
                <a href="<?php echo e(route('admin.kyc.create')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Add Form'); ?></a>
            </div>

            <div class="table-responsive">
                <table class="table table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo app('translator')->get('No.'); ?></th>
                        <th><?php echo app('translator')->get('Form Type'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $kycList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->index + 1); ?></td>
                            <td>
                                <?php echo app('translator')->get($kyc->name); ?>
                            </td>
                            <td>
                                <?php if($kyc->status ==  0): ?>
                                    <span class="badge bg-soft-danger text-danger">
                                                <span class="legend-indicator bg-danger"></span><?php echo app('translator')->get('Inactive'); ?>
                                            </span>
                                <?php elseif($kyc->status ==  1): ?>
                                    <span class="badge bg-soft-success text-success">
                                                <span class="legend-indicator bg-success"></span><?php echo app('translator')->get('Active'); ?>
                                                </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a class="btn btn-white btn-sm" href="<?php echo e(route('admin.kyc.edit', $kyc->id)); ?>">
                                    <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get("Edit"); ?>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr class="odd"><td valign="top" colspan="8" class="dataTables_empty"><div class="text-center p-4">
                                    <img class="mb-3 dataTables-image" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                                    <img class="mb-3 dataTables-image" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                                    <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                </div></td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/vendor/flatpickr/dist/flatpickr.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/vendor/flatpickr/dist/flatpickr.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function () {
            HSCore.components.HSFlatpickr.init('.js-flatpickr')
        })();
    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/kyc/list.blade.php ENDPATH**/ ?>