<?php if(isset($tour_two) && !empty($tour_two['single'])): ?>
    <section class="tour-section-5 section-bg-2 fix">
        <div class="tour-wrapper-5 section-padding bg-cover" style="background-image: url(<?php echo e(getFile($tour_two['single']['media']->background_image->driver, $tour_two['single']['media']->background_image->path)); ?>);">
            <div class="container">
                <div class="section-title style-2 text-center">
                    <span class="wow fadeInUp"><?php echo e($tour_two['single']['title'] ?? ''); ?></span>
                    <h2 class="text-white wow fadeInUp" data-wow-delay=".3s"><?php echo e($tour_two['single']['sub_title_one'] ?? ''); ?><br><?php echo e($tour_two['single']['sub_title_two'] ?? ''); ?></h2>
                </div>
            </div>
            <div class="swiper tour-slider-5">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = $tour_two['packages'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <div class="tour-box-items-6">
                                <div class="tour-image">
                                    <img src="<?php echo e(getFile($package->thumb_driver, $package->thumb)); ?>" alt="<?php echo e($package->title ?? ''); ?>">
                                    <div class="star">
                                        <?php echo displayStarRating($package->avg_rating); ?>

                                        <span>(<?php echo e($package->reviews_count ?? 0); ?>) <?php echo app('translator')->get('Reviews'); ?></span>
                                    </div>
                                </div>
                                <div class="tour-content">
                                    <h6><?php echo app('translator')->get('From'); ?> <span><?php echo e(discountPrice($package)); ?></span> <del><?php echo e(currencyPosition($package->adult_price ?? '0')); ?></del></h6>
                                    <h5>
                                        <a href="<?php echo e(route('package.details', $package->slug)); ?>">
                                            <?php echo app('translator')->get($package->title); ?>
                                        </a>
                                    </h5>
                                    <ul>
                                        <?php if(isset($package->address)): ?>
                                            <li>
                                                <i class="far fa-map-marker-alt"></i>
                                                <?php echo e($package->address); ?>

                                            </li>
                                        <?php endif; ?>
                                        <?php if(isset($package->duration)): ?>
                                                <li>
                                                    <i class="far fa-calendar"></i>
                                                    <?php echo e($package->duration); ?>

                                                </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="swiper-dot4 mt-5 text-center">
                <div class="dot1"></div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/sections/tour_two.blade.php ENDPATH**/ ?>