<div id="recentDevicesSection" class="card">
    <div class="card-header">
        <h2 class="card-title h4"><?php echo app('translator')->get('Recent devices'); ?></h2>
    </div>
    <div class="card-body text-center">
        <?php if(count($userLoginInfo) == 0): ?>
            <div class="card-body ">
                <img class="avatar avatar-xxl mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                     alt="Image Description" data-hs-theme-appearance="default">
                <img class="avatar avatar-xxl mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>"
                     alt="Image Description" data-hs-theme-appearance="dark">
                <p class="card-text"><?php echo app('translator')->get("No data to show"); ?></p>
            </div>
        <?php else: ?>
            <p class="card-text text-start"><?php echo app('translator')->get("View and manage devices where you're currently logged in."); ?></p>
        <?php endif; ?>
    </div>

    <?php if(0 < count($userLoginInfo)): ?>
        <div class="table-responsive">
            <table class="table table-thead-bordered table-nowrap table-align-middle card-table">
                <thead class="thead-light">
                <tr>
                    <th><?php echo app('translator')->get('Browser'); ?></th>
                    <th><?php echo app('translator')->get('Device'); ?></th>
                    <th><?php echo app('translator')->get('Location'); ?></th>
                    <th><?php echo app('translator')->get('Most recent activity'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $userLoginInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $userLogin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="align-items-center">
                            <img class="avatar avatar-xss me-2"
                                 src="<?php echo e(asset("assets/admin/img/browser/".browserIcon($userLogin->browser).".svg")); ?>"
                                 alt="Image Description"> <?php echo e($userLogin->browser); ?> on <?php echo e($userLogin->os); ?>

                        </td>
                        <td>
                            <i class="<?php echo e(deviceIcon($userLogin->get_device)); ?> fs-3 me-2"></i> <?php echo e($userLogin->get_device); ?>

                            <?php if($key== 0 ): ?>
                                <span
                                    class="badge bg-soft-success text-success ms-1"><?php echo app('translator')->get("Current"); ?></span>
                            <?php endif; ?></td>
                        <td><?php echo e($userLogin->country); ?></td>
                        <td><?php echo e(timeAgo($userLogin->created_at)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                <?php endif; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

</div>


<?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/components/recent_devices_section.blade.php ENDPATH**/ ?>