<div id="preferencesSection" class="card">
    <div class="card-header">
        <h2 class="card-title h4"><?php echo app('translator')->get('Preferences'); ?></h2>
    </div>
    <div class="card-body">
        <form action="<?php echo e(route('admin.user.preferences.update', $user->id)); ?>" method="post"
              enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row mb-4">
                <label for="languageLabel"
                       class="col-sm-3 col-form-label form-label">
                    <?php echo app('translator')->get('Language'); ?>
                    <i class="bi bi-info-circle text-body ms-1" data-bs-toggle="tooltip" data-bs-placement="top"
                       aria-label="Select the language for email template and others services."
                       data-bs-original-title="Select the language for email template and others services."></i>
                </label>
                <div class="col-sm-9">
                    <div class="tom-select-custom">
                        <select class="js-select form-select" id="languageLabel" name="language_id"
                                data-hs-tom-select-options='{
                                  "searchInDropdown": false
                                }'>
                            <?php $__empty_1 = true; $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($lang->id); ?>" <?php echo e($user->language_id == $lang->id ? 'selected' : ''); ?>

                                data-option-template='<span class="d-flex align-items-center"><span><?php echo e($lang->name); ?></span></span>'>
                                    <?php echo e($lang->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row mb-4">
                <label for="timeZoneLabel" class="col-sm-3 col-form-label form-label">
                    <?php echo app('translator')->get('Time zone'); ?>
                </label>
                <div class="col-sm-9">
                    <div class="tom-select-custom">
                        <select
                            class="js-select form-select <?php $__errorArgs = ['time_zone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="timeZoneLabel" name="time_zone">
                            <?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option
                                    value="<?php echo e($value); ?>" <?php echo e((old('time_zone',$user->time_zone) == $value ? ' selected' : '')); ?>><?php echo e(__($value)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <?php $__errorArgs = ['time_zone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>



            </div>
            <label class="row form-check form-switch mb-4" for="emailVerificationSwitch">
                    <span class="col-8 col-sm-9 ms-0">
                      <span class="d-block text-dark"><?php echo app('translator')->get('Email Verification'); ?></span>
                      <span
                          class="d-block fs-5"><?php echo app('translator')->get('Email verification codes add reliable security to your systems.'); ?></span>
                    </span>
                <span class="col-4 col-sm-3 text-end">
                     <input type="hidden" name="email_verification" value="0">
                      <input type="checkbox" class="form-check-input" name="email_verification"
                             id="emailVerificationSwitch" value="1" <?php echo e($user->email_verification == 1 ? 'checked' : ''); ?>>
                    </span>
            </label>

            <label class="row form-check form-switch mb-4" for="SMSVerificationSwitch">
                    <span class="col-8 col-sm-9 ms-0">
                      <span class="d-block text-dark"><?php echo app('translator')->get('SMS Verification'); ?></span>
                      <span
                          class="d-block fs-5"><?php echo app('translator')->get('SMS verification codes add reliable security to your systems.'); ?></span>
                    </span>
                <span class="col-4 col-sm-3 text-end">
                        <input type="hidden" name="sms_verification" value="0">
                        <input type="checkbox" class="form-check-input" name="sms_verification"
                               id="SMSVerificationSwitch" value="1" <?php echo e($user->sms_verification == 1 ? 'checked' : ''); ?>>
                    </span>
            </label>

            <div class="d-flex justify-content-start">
                <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save Changes'); ?></button>
            </div>
        </form>
    </div>
</div>

<?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/components/preferences_section.blade.php ENDPATH**/ ?>