<div id="twoStepVerificationSection" class="card">
    <div class="card-header">
        <div class="d-flex align-items-center">
            <h4 class="mb-0"><?php echo app('translator')->get('Two-step verification'); ?></h4>
            <span
                class="badge bg-soft-<?php echo e($user->two_fa_verify == 1 ? 'success' : 'danger'); ?> text-<?php echo e($user->two_fa_verify == 1 ? 'success' : 'danger'); ?> ms-2"><?php echo e($user->two_fa_verify == 1 ? 'Enable' : 'Disabled'); ?></span>
        </div>

    </div>

    <div class="card-body">
        <p class="card-text">
            <?php echo app('translator')->get('Your security is our top priority, and Two-Step Verification is a powerful tool to keep your account safe. We highly recommend enabling it today.'); ?>
        </p>
        <form action="<?php echo e(route('admin.user.twoFa.update', $user->id)); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="d-flex justify-content-start">
                <button type="submit" class="btn btn-<?php echo e($user->two_fa_verify == 1 ? 'danger' : 'primary'); ?>"
                        name="two_fa_security"
                        value="<?php echo e($user->two_fa_verify); ?>"><?php echo e($user->two_fa_verify == 1 ? 'Disable' : 'Enable'); ?></button>
            </div>
        </form>
    </div>
</div>
<?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/components/two_step_verify_section.blade.php ENDPATH**/ ?>