
<?php $__env->startSection('page_title',__('Edit User')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0)"><?php echo app('translator')->get('User Management'); ?></a></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Edit User'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Edit @'. $user->username . ' Profile'); ?></h1>
                </div>
                <div class="col-sm-auto">
                    <a class="btn btn-primary" href="<?php echo e(route('admin.user.view.profile', $user->id)); ?>">
                        <i class="bi-eye-fill me-1"></i> <?php echo app('translator')->get('View Profile'); ?>
                    </a>
                </div>
            </div>
        </div>


        <div class="row">
            <div class="col-lg-3">
                <div class="navbar-expand-lg navbar-vertical mb-3 mb-lg-5">
                    <div class="d-grid">
                        <button type="button" class="navbar-toggler btn btn-white mb-3" data-bs-toggle="collapse"
                                data-bs-target="#navbarVerticalNavMenu" aria-label="Toggle navigation"
                                aria-expanded="false" aria-controls="navbarVerticalNavMenu">
                                <span class="d-flex justify-content-between align-items-center">
                                  <span class="text-dark"><?php echo app('translator')->get('Menu'); ?></span>
                                  <span class="navbar-toggler-default">
                                    <i class="bi-list"></i>
                                  </span>
                                  <span class="navbar-toggler-toggled">
                                    <i class="bi-x"></i>
                                </span>
                            </span>
                        </button>
                    </div>

                    <div id="navbarVerticalNavMenu" class="collapse navbar-collapse">
                        <ul id="navbarSettings"
                            class="js-sticky-block js-scrollspy card card-navbar-nav nav nav-tabs nav-lg nav-vertical"
                            data-hs-sticky-block-options='{
                             "parentSelector": "#navbarVerticalNavMenu",
                             "targetSelector": "#header",
                             "breakpoint": "lg",
                             "startPoint": "#navbarVerticalNavMenu",
                             "endPoint": "#stickyBlockEndPoint",
                             "stickyOffsetTop": 20
                           }'>
                            <li class="nav-item">
                                <a class="nav-link active" href="#content">
                                    <i class="bi-person nav-icon"></i> <?php echo app('translator')->get('Basic information'); ?>
                                </a>
                            </li>
                            <?php if($user->role == 1): ?>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#payment_collection">
                                        <i class="bi-cash nav-icon"></i> <?php echo app('translator')->get('Payment Collection'); ?>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <li class="nav-item">
                                <a class="nav-link" href="#emailSection">
                                    <i class="bi-at nav-icon"></i> <?php echo app('translator')->get('Email'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#usernameSection">
                                    <i class="bi bi-person nav-icon"></i><?php echo app('translator')->get('Username'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#passwordSection">
                                    <i class="bi-key nav-icon"></i> <?php echo app('translator')->get('Password'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#preferencesSection">
                                    <i class="bi-gear nav-icon"></i> <?php echo app('translator')->get('Preferences'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#twoStepVerificationSection">
                                    <i class="bi-shield-lock nav-icon"></i> <?php echo app('translator')->get('Two-step verification'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#recentDevicesSection">
                                    <i class="bi-phone nav-icon"></i> <?php echo app('translator')->get('Recent devices'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#deleteAccountSection">
                                    <i class="bi-trash nav-icon"></i> <?php echo app('translator')->get('Delete account'); ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>


            <div class="col-lg-9">
                <div class="d-grid gap-3 gap-lg-5">
                    <form action="<?php echo e(route('admin.user.update', $user->id)); ?>" method="post"
                          enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="profile-cover">
                            <div class="profile-cover-img-wrapper">
                                <img id="profileCoverImg" class="profile-cover-img"
                                     src="<?php echo e(asset('assets/admin/img/img1.jpg')); ?>"
                                     alt="Image Description">
                            </div>
                        </div>

                        <label class="avatar avatar-xxl avatar-circle avatar-uploader profile-cover-avatar"
                               for="editAvatarUploaderModal">
                            <img id="editAvatarImgModal" class="avatar-img"
                                 src="<?php echo e(getFile($user->image_driver, $user->image)); ?>"
                                 alt="Image Description">
                            <input type="file" class="js-file-attach avatar-uploader-input" id="editAvatarUploaderModal"
                                   name="image"
                                   data-hs-file-attach-options='{
                                    "textTarget": "#editAvatarImgModal",
                                    "mode": "image",
                                    "targetAttr": "src",
                                    "allowTypes": [".png", ".jpeg", ".jpg"]
                                 }'>
                            <span class="avatar-uploader-trigger">
                          <i class="bi-pencil-fill avatar-uploader-icon shadow-sm"></i>
                        </span>
                        </label>

                        <div class="card">
                            <div class="card-header">
                                <h2 class="card-title h4"><?php echo app('translator')->get('Basic information'); ?></h2>
                            </div>
                            <div class="card-body">
                                <div class="row mb-4">
                                    <label for="firstNameLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Full name'); ?></label>
                                    <div class="col-sm-9">
                                        <div class="input-group input-group-sm-vertical">
                                            <input type="text" class="form-control" name="firstName" id="firstNameLabel"
                                                   placeholder="First name" aria-label="First name"
                                                   value="<?php echo e(old('firstName', $user->firstname)); ?>" autocomplete="off">
                                            <input type="text" class="form-control" name="lastName" id="lastNameLabel"
                                                   placeholder="Last name" aria-label="Last name"
                                                   value="<?php echo e(old('lastName', $user->lastname)); ?>" autocomplete="off">
                                        </div>
                                        <?php $__errorArgs = ['firstName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-inline"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <?php $__errorArgs = ['lastName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-inline"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>


                                <div class="row mb-4">
                                    <label for="phoneLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Phone'); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" class="js-input-mask form-control" name="phone"
                                               id="phoneLabel" placeholder="Phone"
                                               aria-label="Phone" value="<?php echo e(old('phone', $user->phone)); ?>"
                                               autocomplete="off">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <label for="locationLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Country'); ?></label>
                                    <div class="col-sm-9">
                                        <div class="tom-select-custom mb-4">
                                            <select class="js-select form-select" id="locationLabel" name="country">
                                                <?php $__empty_1 = true; $__currentLoopData = $allCountry; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <option value="<?php echo e($country['name']); ?>"
                                                            <?php echo e($country['name'] == $user->country ? 'selected' : ''); ?>

                                                            data-option-template='<span class="d-flex align-items-center"><img class="avatar avatar-xss avatar-circle me-2" src="<?php echo e(asset($country['flag'])); ?>" alt="Afghanistan Flag" /><span class="text-truncate"><?php echo e($country['name']); ?></span></span>'>
                                                        <?php echo app('translator')->get($country['name']); ?>
                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-3">
                                            <div class="input-group input-group-sm-vertical">
                                                <input type="text" class="form-control" name="city" id="cityLabel"
                                                       placeholder="City" aria-label="City"
                                                       value="<?php echo e(old('city', $user->city)); ?>" autocomplete="off">
                                                <input type="text" class="form-control" name="state" id="stateLabel"
                                                       placeholder="State" aria-label="State"
                                                       value="<?php echo e(old('state', $user->state)); ?>">

                                                <input type="text" class="js-input-mask form-control" name="zipCode"
                                                       id="zipCodeLabel" placeholder="Zip code" aria-label="Zip code"
                                                       value="<?php echo e(old('zipCode', $user->zip_code)); ?>" autocomplete="off">
                                            </div>
                                            <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-inline"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-inline"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                            <?php $__errorArgs = ['zipCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <label for="addressLine1Label" class="col-sm-3 col-form-label form-label">
                                        <?php echo app('translator')->get('Address line 1'); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="addressOne"
                                               id="addressLine1Label" placeholder="Address One"
                                               aria-label="Your address"
                                               value="<?php echo e(old('addressOne', $user->address_one)); ?>" autocomplete="off">
                                        <?php $__errorArgs = ['addressOne'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>


                                <div class="row mb-4">
                                    <label for="addressLine2Label" class="col-sm-3 col-form-label form-label">
                                        <?php echo app('translator')->get('Address line 2'); ?>
                                        <span class="form-label-secondary">(<?php echo app('translator')->get("Optional"); ?>)</span></label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="addressTwo"
                                               id="addressLine2Label" placeholder="Address Two"
                                               aria-label="Address Two"
                                               value="<?php echo e(old('addressTwo', $user->address_two)); ?>" autocomplete="off">
                                        <?php $__errorArgs = ['addressTwo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>


                                <label class="row form-check form-switch mb-4" for="userStatusSwitch">
                                    <span class="col-8 col-sm-3 ms-0">
                                      <span class="d-block text-dark"><?php echo app('translator')->get('Status'); ?></span>
                                    </span>
                                    <span class="col-4 col-sm-3">
                                         <input type="hidden" name="status" value="0">
                                      <input type="checkbox" class="form-check-input" name="status"
                                             id="userStatusSwitch" value="1" <?php echo e($user->status == 1 ? 'checked' : ''); ?>>
                                    </span>
                                </label>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <div class="d-flex justify-content-start">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
                                </div>
                            </div>
                        </div>
                        <!-- End Card -->
                    </form>


                    <?php if($user->role == 1): ?>
                        <?php echo $__env->make('admin.user_management.components.payment_collection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>

                    <?php echo $__env->make('admin.user_management.components.email_section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.user_management.components.username_section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.user_management.components.password_section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                    <?php echo $__env->make('admin.user_management.components.preferences_section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                    <?php echo $__env->make('admin.user_management.components.two_step_verify_section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                    <?php echo $__env->make('admin.user_management.components.recent_devices_section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                    <?php echo $__env->make('admin.user_management.components.delete_account_section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                </div>
                <div id="stickyBlockEndPoint"></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/hs-file-attach.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/hs-sticky-block.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/hs-scrollspy.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function () {
            $('.delete-btn').prop('disabled', true);
            $('#deleteAccountCheckbox').on('change', function() {
                let checkboxValue = $(this).prop('checked');
                $('.delete-btn').prop('disabled', !checkboxValue);
            });

            HSCore.components.HSTomSelect.init('.js-select', {
                maxOptions: 250
            })

            new HSFileAttach('.js-file-attach')
            new HSStickyBlock('.js-sticky-block', {
                targetSelector: document.getElementById('header').classList.contains('navbar-fixed') ? '#header' : null
            })
            new bootstrap.ScrollSpy(document.body, {
                target: '#navbarSettings',
                offset: 100
            })
            new HSScrollspy('#navbarVerticalNavMenu', {
                breakpoint: 'lg',
                scrollOffset: -20
            })
        })

    </script>
<?php $__env->stopPush(); ?>






<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/edit_user.blade.php ENDPATH**/ ?>