
<?php $__env->startSection('page_title',trans('Profile')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="row justify-content-lg-center">
            <div class="col-lg-10">
                <div class="page-header custom-header">
                    <div class="row align-items-end">
                        <div class="col-sm">
                            <h1 class="page-header-title"><?php echo app('translator')->get("Profile"); ?></h1>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb breadcrumb-no-gutter">
                                    <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                                   href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                    <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get("User Profile"); ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-3">
                        <!-- Navbar -->
                        <div class="navbar-expand-lg navbar-vertical mb-3 mb-lg-5">
                            <div class="d-grid">
                                <button type="button" class="navbar-toggler btn btn-white mb-3" data-bs-toggle="collapse" data-bs-target="#navbarVerticalNavMenu" aria-label="Toggle navigation" aria-expanded="false" aria-controls="navbarVerticalNavMenu">
                                    <span class="d-flex justify-content-between align-items-center">
                                      <span class="text-dark"><?php echo app('translator')->get('Menu'); ?></span>

                                      <span class="navbar-toggler-default">
                                        <i class="bi-list"></i>
                                      </span>

                                      <span class="navbar-toggler-toggled">
                                        <i class="bi-x"></i>
                                      </span>
                                    </span>
                                </button>
                            </div>
                            <!-- End Navbar Toggle -->
                            <!-- End Navbar Toggle -->

                            <!-- Navbar Collapse -->
                            <div id="navbarVerticalNavMenu" class="collapse navbar-collapse">
                                <ul id="navbarSettings" class="js-sticky-block js-scrollspy card card-navbar-nav nav nav-tabs nav-lg nav-vertical" data-hs-sticky-block-options='{
                             "parentSelector": "#navbarVerticalNavMenu",
                             "targetSelector": "#header",
                             "breakpoint": "lg",
                             "startPoint": "#navbarVerticalNavMenu",
                             "endPoint": "#stickyBlockEndPoint",
                             "stickyOffsetTop": 20
                           }'>
                                    <li class="nav-item">
                                        <a class="nav-link active" href="#content">
                                            <i class="bi-person nav-icon"></i> <?php echo app('translator')->get('Basic information'); ?>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="#passwordSection">
                                            <i class="bi-key nav-icon"></i> <?php echo app('translator')->get('Password'); ?>
                                        </a>
                                    </li>
                                    <?php if(auth()->user()->role == 1): ?>
                                        <li class="nav-item">
                                            <a class="nav-link" href="#deleteAccountSection">
                                                <i class="bi-trash nav-icon"></i> <?php echo app('translator')->get('Delete account'); ?>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-9">
                        <div class="d-grid gap-3 gap-lg-5">
                            <div class="card">
                                <div class="profile-cover">
                                    <div class="profile-cover-img-wrapper">
                                        <img id="profileCoverImg" class="profile-cover-img" src="<?php echo e(asset(template(true).'img/img2.jpg')); ?>" alt="Image Description">

                                    </div>
                                </div>
                                <form id="avatarUploadForm" action="<?php echo e(route('user.profile.update.image')); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <label class="avatar avatar-xxl avatar-circle avatar-uploader profile-cover-avatar" for="editAvatarUploaderModal">
                                        <img id="editAvatarImgModal" class="avatar-img" src="<?php echo e(getFile(auth()->user()->image_driver, auth()->user()->image)); ?>" alt="Image Description">

                                        <input type="file" name="image" class="js-file-attach avatar-uploader-input" id="editAvatarUploaderModal"
                                               data-hs-file-attach-options='{
                                                   "textTarget": "#editAvatarImgModal",
                                                   "mode": "image",
                                                   "targetAttr": "src",
                                                   "allowTypes": [".png", ".jpeg", ".jpg"]
                                               }' onchange="document.getElementById('avatarUploadForm').submit();">

                                        <span class="avatar-uploader-trigger">
                                            <i class="bi-pencil-fill avatar-uploader-icon shadow-sm"></i>
                                        </span>
                                    </label>
                                </form>
                                <!-- End Avatar -->

                                <!-- Body -->
                                <div class="card-body">
                                    <div class="row align-items-center justify-content-center w-100">
                                        <div class="col-sm-5 w-100 text-center">
                                            <h1 class="page-header-title text-center">
                                                <?php echo app('translator')->get(auth()->user()->firstname. ' ' . auth()->user()->lastname); ?>
                                            </h1>
                                            <ul class="list-inline list-px-2">
                                                <?php if(isset(auth()->user()->address_one) || isset(auth()->user()->city) || isset(auth()->user()->country)): ?>
                                                    <li class="list-inline-item">
                                                        <i class="bi-geo-alt me-1"></i>
                                                        <?php if(isset(auth()->user()->address_one)): ?>
                                                            <span><?php echo app('translator')->get(auth()->user()->address_one); ?>,</span>
                                                        <?php endif; ?>
                                                        <?php if(isset(auth()->user()->city)): ?>
                                                            <span><?php echo app('translator')->get(auth()->user()->city); ?>,</span>
                                                        <?php endif; ?>
                                                        <?php if(isset(auth()->user()->country)): ?>
                                                            <span><?php echo app('translator')->get(auth()->user()->country); ?></span>
                                                        <?php endif; ?>
                                                    </li>
                                                <?php endif; ?>

                                                <?php if(isset(auth()->user()->created_at)): ?>
                                                    <li class="list-inline-item">
                                                        <i class="bi-calendar-week me-1"></i>
                                                        <span><?php echo e('Joined ' . dateTime(auth()->user()->created_at, 'M Y')); ?></span>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <h2 class="card-title h4"><?php echo app('translator')->get('Basic information'); ?></h2>
                                </div>

                                <div class="card-body">
                                    <form action="<?php echo e(route('user.profile.update')); ?>" method="post"
                                          enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>

                                        <div class="row mb-4">
                                            <label for="firstNameLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Full name'); ?> <i class="bi-question-circle text-body ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Displayed on public forums, such as Front."></i></label>

                                            <div class="col-sm-9">
                                                <div class="input-group input-group-sm-vertical">
                                                    <input type="text" class="form-control" name="firstname" id="firstNameLabel" placeholder="Your first name" aria-label="Your first name" value="<?php echo e(old('firstname', auth()->user()->firstname)); ?>">
                                                    <input type="text" class="form-control" name="lastname" id="lastNameLabel" placeholder="Your last name" aria-label="Your last name" value="<?php echo e(old('lastname', auth()->user()->lastname)); ?>">
                                                </div>
                                                <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="row mb-4">
                                            <label for="usernameLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Username'); ?></label>

                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="username" id="usernameLabel" placeholder="<?php echo app('translator')->get('e.g. david'); ?>" aria-label="<?php echo app('translator')->get('username'); ?>" value="<?php echo e(old('username', auth()->user()->username)); ?>">
                                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="row mb-4">
                                            <label for="emailLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Email'); ?></label>

                                            <div class="col-sm-9">
                                                <input type="email" class="form-control" name="email" id="emailLabel" placeholder="Email" aria-label="Email" value="<?php echo e(old('email', auth()->user()->email)); ?>">
                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="row mb-4">
                                            <label for="phoneLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Phone'); ?></label>

                                            <div class="col-sm-9">
                                                <div class="input-group">
                                                    <select class="form-select js-select w-auto d-inline-block" name="phone_code" id="phoneCode" aria-label="Phone code">
                                                        <?php $__currentLoopData = config('country') ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($code['phone_code']); ?>" <?php echo e((auth()->user()->phone_code == $code['phone_code']) ? 'selected': ''); ?>><?php echo e($code['phone_code']); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <input type="text" class="js-input-mask form-control" name="phone" id="phoneLabel" placeholder="(xxx)xxx-xx-xx" aria-label="(xxx)xxx-xx-xx" value="<?php echo e(auth()->user()->phone); ?>" data-hs-mask-options='{
                                                       "mask": "0000000000"
                                                     }'>
                                                </div>
                                                <?php $__errorArgs = ['phone_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="row mb-4">
                                            <label for="addressOneLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Address One'); ?></label>

                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="address_one" id="addressOneLabel" placeholder="e.g H/41, NY, USA" aria-label="<?php echo app('translator')->get('Address One'); ?>" value="<?php echo e(auth()->user()->address_one); ?>">
                                                <?php $__errorArgs = ['address_one'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="row mb-4">
                                            <label for="addressTwoLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Address Two'); ?></label>

                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="address_two" id="addressTwoLabel" placeholder="e.g H/41, NY, USA" aria-label="<?php echo app('translator')->get('Address Two'); ?>" value="<?php echo e(auth()->user()->address_two); ?>">
                                                <?php $__errorArgs = ['address_two'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="row mb-4">
                                            <label for="zipCodeLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Zip Code'); ?></label>

                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="zipcode" id="zipCodeLabel" placeholder="e.g. 1000" aria-label="<?php echo app('translator')->get('Zip Code'); ?>" value="<?php echo e(auth()->user()->zip_code); ?>">
                                                <?php $__errorArgs = ['zipcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div id="accountType" class="row mb-4">
                                            <label class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('About Me'); ?></label>

                                            <div class="col-sm-9">
                                                <textarea class="form-control" name="about_me" placeholder="<?php echo app('translator')->get('Text about me'); ?>"><?php echo e(auth()->user()->about_me); ?></textarea>
                                                <?php $__errorArgs = ['about_me'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="row mb-4">
                                            <label for="locationLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Location'); ?></label>

                                            <div class="col-sm-9">
                                                <div class="tom-select-custom mb-4">
                                                    <select id="country" class="js-select form-select" name="country" id="locationLabel">
                                                        <?php $__currentLoopData = $counties ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($country->id); ?>" data-option-template='<span class="d-flex align-items-center"><img class="avatar avatar-xss avatar-circle me-2" src="<?php echo e(getFile($country->image_driver, $country->image)); ?>" alt="<?php echo e($country->name .' Flag'); ?>" /><span class="text-truncate"><?php echo e($country->name ?? ''); ?></span></span>'><?php echo e($country->name ?? ''); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback d-block" role="alert">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label" for="state"><?php echo app('translator')->get('State'); ?></label>
                                                    <select name="state" id="state" class="form-select js-select">
                                                        <option value="<?php echo e(optional(auth()->user()->stateTake)->id); ?>" <?php echo e(( optional(auth()->user()->stateTake)->name == auth()->user()->state) ? 'selected' : ''); ?>><?php echo app('translator')->get(optional(auth()->user()->stateTake)->name); ?></option>
                                                    </select>
                                                    <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback d-block" role="alert">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="mb-4">
                                                    <label class="form-label" for="city"><?php echo app('translator')->get('City'); ?></label>
                                                    <select name="city" id="city" class="form-select js-select">
                                                        <option value="<?php echo e(optional(auth()->user()->cityTake)->id); ?>" <?php echo e(( optional(auth()->user()->cityTake)->name == auth()->user()->city) ? 'selected' : ''); ?>><?php echo app('translator')->get(optional(auth()->user()->cityTake)->name); ?></option>
                                                    </select>
                                                    <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback d-block" role="alert">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                                <div class="mb-4">
                                                    <label class="form-label" for="language"><?php echo app('translator')->get('Prefered Language'); ?></label>
                                                    <select name="language" id="language" class="form-select js-select">
                                                        <?php $__currentLoopData = $languages ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($lang->id); ?>" <?php echo e((auth()->user()->language_id == $lang->id) ? 'selected' : ''); ?>><?php echo e($lang->name ?? ''); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback d-block" role="alert">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(auth()->user()->role == 1): ?>
                                            <div class="row mb-4">
                                                <label for="locationLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Links'); ?></label>
                                                <div class="col-sm-9">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="facebook_link"><?php echo app('translator')->get('Facebook Link'); ?></label>
                                                        <input type="text" class="form-control" name="facebook_link" id="facebook_link" placeholder="e.g https://www.facebook.com/" aria-label="<?php echo app('translator')->get('Facebook Link'); ?>" value="<?php echo e($vendorInfo->facebook_link); ?>">
                                                        <?php $__errorArgs = ['facebook_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback d-block" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label" for="twitter_link"><?php echo app('translator')->get('Twitter Link'); ?></label>

                                                        <input type="text" class="form-control" name="twitter_link" id="twitter_link" placeholder="e.g https://www.x.com/" aria-label="<?php echo app('translator')->get('Twitter Link'); ?>" value="<?php echo e($vendorInfo->twitter_link); ?>">
                                                        <?php $__errorArgs = ['twitter_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback d-block" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label" for="instagram_link"><?php echo app('translator')->get('Instagram Link'); ?></label>
                                                        <input type="text" class="form-control" name="instagram_link" id="instagram_link" placeholder="e.g https://www.instagram.com/" aria-label="<?php echo app('translator')->get('Instagram Link'); ?>" value="<?php echo e($vendorInfo->instagram_link); ?>">
                                                        <?php $__errorArgs = ['instagram_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback d-block" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label class="form-label" for="linkedin_link"><?php echo app('translator')->get('Linkedin Link'); ?></label>
                                                        <input type="text" class="form-control" name="linkedin_link" id="linkedin_link" placeholder="e.g https://www.linkedin.com/" aria-label="<?php echo app('translator')->get('Linkedin Link'); ?>" value="<?php echo e($vendorInfo->linkedin_link); ?>">
                                                        <?php $__errorArgs = ['linkedin_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback d-block" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="d-flex justify-content-end">
                                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <div id="passwordSection" class="card">
                                <div class="card-header">
                                    <h4 class="card-title"><?php echo app('translator')->get('Change your password'); ?></h4>
                                </div>

                                <div class="card-body">
                                    <form action="<?php echo e(route('user.updatePassword')); ?>" method="post">
                                        <?php echo csrf_field(); ?>

                                        <div class="row mb-4">
                                            <label for="currentPasswordLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Current password'); ?></label>
                                            <div class="col-sm-9 position-relative">
                                                <input type="password" class="form-control" name="current_password" id="currentPasswordLabel" placeholder="Enter current password" aria-label="<?php echo app('translator')->get('Enter current password'); ?>">
                                                <i class="fa fa-eye-slash toggle-password" id="toggleCurrentPassword"></i>
                                                <?php if($errors->has('current_password')): ?>
                                                    <div class="error text-danger"><?php echo app('translator')->get($errors->first('current_password')); ?> </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="row mb-4">
                                            <label for="newPassword" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('New password'); ?></label>
                                            <div class="col-sm-9 position-relative">
                                                <input type="password" class="form-control" name="password" id="newPassword" placeholder="<?php echo app('translator')->get('Enter new password'); ?>" aria-label="<?php echo app('translator')->get('Enter new password'); ?>">
                                                <i class="fa fa-eye-slash toggle-password" id="toggleNewPassword"></i>
                                                <?php if($errors->has('password')): ?>
                                                    <div class="error text-danger"><?php echo app('translator')->get($errors->first('password')); ?> </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="row mb-4">
                                            <label for="confirmNewPasswordLabel" class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get('Confirm new password'); ?></label>
                                            <div class="col-sm-9 ">
                                                <div class="mb-3 position-relative">
                                                    <input type="password" class="form-control" name="password_confirmation" id="confirmNewPasswordLabel" placeholder="<?php echo app('translator')->get('Confirm your new password'); ?>" aria-label="<?php echo app('translator')->get('Confirm your new password'); ?>">
                                                    <i class="fa fa-eye-slash toggle-password toggle-password-confirm" id="toggleConfirmPassword"></i>
                                                </div>
                                                <div id="password-match-message" class="text-sm"></div>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-end">
                                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save Changes'); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <?php if(auth()->user()->role == 1): ?>
                                <div id="deleteAccountSection" class="card">
                                    <div class="card-header">
                                        <h4 class="card-title"><?php echo app('translator')->get('Delete your account'); ?></h4>
                                    </div>

                                    <div class="card-body">
                                        <form action="<?php echo e(route('user.delete.account')); ?>" method="GET">
                                            <p class="card-text"><?php echo app('translator')->get('When you delete your account, you lose access to Front account services, and we permanently delete your personal data. You can cancel the deletion for 14 days.'); ?></p>

                                            <div class="mb-4">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="deleteConfirm" value="1" id="deleteAccountCheckbox">
                                                    <label class="form-check-label" for="deleteAccountCheckbox">
                                                        <?php echo app('translator')->get('Confirm that I want to delete my account.'); ?>
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="d-flex justify-content-end gap-3">
                                                <button type="submit" class="btn btn-danger"><?php echo app('translator')->get('Delete'); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div id="stickyBlockEndPoint"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
    <style>
        .position-relative {
            position: relative;
        }

        .toggle-password {
            position: absolute;
            top: 45%;
            right: 25px;
            transform: translateY(-50%);
            cursor: pointer;
        }
        .toggle-password-confirm{
            right: 15px !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <?php if($errors->any()): ?>
        <script>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.failure("<?php echo e($error); ?>");
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </script>
    <?php endif; ?>
    <script>
        document.getElementById('toggleCurrentPassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('currentPasswordLabel');
            const icon = this;
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            } else {
                passwordInput.type = 'password';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            }
        });

        document.getElementById('toggleNewPassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('newPassword');
            const icon = this;
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            } else {
                passwordInput.type = 'password';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            }
        });

        document.getElementById('toggleConfirmPassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('confirmNewPasswordLabel');
            const icon = this;
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            } else {
                passwordInput.type = 'password';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            }
        });

        $(document).ready(function () {
            HSCore.components.HSTomSelect.init('.js-select', {
                placeholder: 'Select One'
            });
            $('#country').on('change', function () {
                let idCountry = this.value;

                if ($('#state')[0].tomselect) {
                    $('#state')[0].tomselect.destroy();
                }
                $("#state").html('');

                $.ajax({
                    url: "<?php echo e(route('user.fetch.state')); ?>",
                    type: "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        "country_id": idCountry,
                    },
                    dataType: 'json',
                    success: function (result) {
                        let stateOptions = '<option value="">-- Select State --</option>';
                        $.each(result.states, function (key, value) {
                            stateOptions += '<option value="' + value.id + '">' + value.name + '</option>';
                        });
                        $("#state").html(stateOptions);

                        HSCore.components.HSTomSelect.init('#state', {
                            maxOptions: 250,
                            placeholder: 'Select State'
                        });
                    }
                });
            });

            //City Dropdown
            $('#state').on('change', function () {
                let idState = this.value;

                if ($('#city')[0].tomselect) {
                    $('#city')[0].tomselect.destroy();
                }

                $("#city").html('');

                $.ajax({
                    url: "<?php echo e(route('user.fetch.city')); ?>",
                    type: "POST",
                    data: {
                        state_id: idState,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function (res) {
                        let cityOptions = '<option value="">-- Select City --</option>';
                        $.each(res.cities, function (key, value) {
                            cityOptions += '<option value="' + value.id + '">' + value.name + '</option>';
                        });
                        $("#city").html(cityOptions);

                        HSCore.components.HSTomSelect.init('#city', {
                            maxOptions: 250,
                            placeholder: 'Select City'
                        });
                    }
                });
            });
        });

        document.getElementById('editAvatarUploaderModal').addEventListener('change', function (event) {
            const file = event.target.files[0];
            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('editAvatarImgModal').src = e.target.result;
                };
                reader.readAsDataURL(file);
            }
        });


        const newPassword = document.getElementById('newPassword');
        const confirmPassword = document.getElementById('confirmNewPasswordLabel');
        const matchMessage = document.getElementById('password-match-message');

        function checkPasswordMatch() {
            const newVal = newPassword.value;
            const confirmVal = confirmPassword.value;

            if (!newVal || !confirmVal) {
                matchMessage.textContent = '';
                matchMessage.classList.remove('text-success', 'text-danger');
                return;
            }

            if (newVal === confirmVal) {
                matchMessage.textContent = 'Passwords match';
                matchMessage.classList.add('text-success');
                matchMessage.classList.remove('text-danger');
            } else {
                matchMessage.textContent = 'Passwords do not match';
                matchMessage.classList.add('text-danger');
                matchMessage.classList.remove('text-success');
            }
        }

        newPassword.addEventListener('keyup', checkPasswordMatch);
        confirmPassword.addEventListener('keyup', checkPasswordMatch);
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make(template().'layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/user/profile/edit_profile.blade.php ENDPATH**/ ?>