
<?php $__env->startSection('page_title',trans('Payouts')); ?>
<?php $__env->startSection('content'); ?>

    <div class="content container-fluid">
        <div class="row justify-content-lg-center">
            <div class="col-lg-10">
                <div class="page-header custom-header">
                    <div class="row align-items-end">
                        <div class="col-sm">
                            <h1 class="page-header-title"><?php echo app('translator')->get("Payouts"); ?></h1>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb breadcrumb-no-gutter">
                                    <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                                   href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                    <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get("User Payout"); ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
                <?php if(!config('withdrawaldays')[date('l')]): ?>
                    <h5 class="p-3 bg-soft-warning text-warning"><?php echo app('translator')->get('Withdraw processing is off today. Please try' ); ?> <?php $__currentLoopData = config('withdrawaldays'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $days): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($days == 1 ? $key.',':''); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></h5>
                <?php endif; ?>
                <form action="<?php echo e(route('user.payout.request')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row g-4">
                        <div class="col-lg-7 col-md-6">
                            <div class="card gateways">
                                <div class="card-header card-header-content-md-between">
                                    <h4 class="card-header-title"><?php echo app('translator')->get('Your preferred payout method?'); ?></h4>
                                </div>
                                <div class="card-body pt-0">
                                    <div class="payment-section">
                                        <ul class="payment-container-list">
                                            <?php $__currentLoopData = $payoutMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="item">
                                                    <input type="radio" class="form-check-input selectPayoutMethod"
                                                           name="payout_method_id"
                                                           id="<?php echo e($method->name); ?>"
                                                           value="<?php echo e($method->id); ?>"
                                                           autocomplete="off"/>
                                                    <label class="form-check-label" for="<?php echo e($method->name); ?>">
                                                        <div class="image-area">
                                                            <img src="<?php echo e(getFile($method->driver, $method->logo)); ?>" alt="">
                                                        </div>
                                                        <div class="content-area">
                                                            <h5><?php echo e($method->name); ?></h5>
                                                            <span><?php echo e($method->description); ?></span>
                                                        </div>
                                                    </label>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                        <button type="button" class="btn btn-primary w-100 d-block d-md-none" id="showGatewaysButton">
                                            <?php echo e(trans('Select Payout Method')); ?>

                                        </button>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex flex-column" >
                                        <label class="form-label mt-3" for="supported_currency"><?php echo e(trans('Select Currency')); ?>

                                            <span data-bs-toggle="tooltip" data-bs-placement="top"
                                                  data-bs-title="Kindly choose the currency through which you'd like to payout using the gateway.">
                                                    <i class="fa-regular fa-circle-question"></i></span>
                                        </label>
                                        <select class="js-select" name="supported_currency" id="supported_currency">
                                            <option value="" selected
                                                    disabled><?php echo e(trans('Select a payout method first')); ?></option>
                                        </select>
                                    </div>


                                    <div>
                                        <label class="form-label mt-3" for=""><?php echo e(trans('Enter Amount')); ?></label>
                                        <input class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="amount" type="text" id="amount"
                                               placeholder="Enter Amount" autocomplete="off"
                                               onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')"
                                        />
                                        <span class="invalid-feedback"><?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></span>
                                        <span class="valid-feedback"></span>
                                    </div>



                                    <div class="side-box mt-3 mb-3">
                                        <div class="showCharge">

                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary w-100 submitBtn mt-3" disabled>
                                        <?php echo e(trans('Payout')); ?>

                                    </button>

                                    <a href="<?php echo e(route('user.dashboard')); ?>" class="btn btn-soft-danger mt-2 w-100"><?php echo e(trans('Cancel')); ?></a>

                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal for Payout Gateways (for mobile) -->
                    <div class="modal fade" id="gatewayModal" tabindex="-1" aria-labelledby="gatewayModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="gatewayModalLabel"><?php echo e(trans('Select a Payout Gateway')); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <ul class="payment-container-list d-lg-none d-block">
                                        <?php $__currentLoopData = $payoutMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="item">
                                                <input type="radio" class="form-check-input selectPayoutMethod"
                                                       name="payout_method_id" value="<?php echo e($method->id); ?>"
                                                       id="modal-<?php echo e($method->id); ?>"
                                                       autocomplete="off"/>
                                                <label class="form-check-label" for="modal-<?php echo e($method->id); ?>">
                                                    <div class="image-area">
                                                        <img src="<?php echo e(getFile($method->driver, $method->logo)); ?>" alt="">
                                                    </div>
                                                    <div class="content-area">
                                                        <h5><?php echo e($method->name); ?></h5>
                                                        <span><?php echo e($method->description); ?></span>
                                                    </div>
                                                </label>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
    <style>
        .form-control{
            height: 38px;
        }
        #oldKyc{
            padding-top: 5px;
        }
        .account-settings-navbar{
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <script>
        'use strict';

        $('#showGatewaysButton').on('click', function () {
            $('#gatewayModal').modal('show');
        });

        function emptyInput() {
            let amountField = $('#amount');
            amountField.val('');
            $('.submitBtn').prop('disabled', true);
            $('.showCharge').html('');
            $(amountField).addClass('is-invalid');
            $(amountField).closest('div').find(".valid-feedback").html('');
            $(amountField).closest('div').find(".invalid-feedback").html('Enter your amount');
        }

        $(document).ready(function () {
            let amountField = $('#amount');
            let btnStatus = false;
            let selectedPayoutMethod = "";
            let base_currency = "<?php echo e(basicControl()->base_currency); ?>"

            HSCore.components.HSTomSelect.init('.js-select', {
                placeholder: 'Select One'
            });


            $(document).on('click', '.selectPayoutMethod', function () {
                let id = this.id;
                $('#gatewayModal').modal('hide');

                selectedPayoutMethod = $(this).val();
                supportCurrency(selectedPayoutMethod);
            });

            function supportCurrency(selectedPayoutMethod) {
                if (!selectedPayoutMethod) {
                    console.error('Selected Gateway is undefined or null.');
                    return;
                }

                const $supportedCurrency = $('#supported_currency');
                const tomSelectInstance = $supportedCurrency[0].tomselect;

                tomSelectInstance.clear(true);
                tomSelectInstance.clearOptions();

                tomSelectInstance.disable();

                $.ajax({
                    url: "<?php echo e(route('user.payout.supported.currency')); ?>",
                    data: { gateway: selectedPayoutMethod },
                    type: "GET",
                    success: function (data) {
                        if (Array.isArray(data) && data.length > 0) {
                            tomSelectInstance.addOption({ value: "", text: "<?php echo e(trans('Choose Currency')); ?>" });

                            data.forEach(function (currency) {
                                tomSelectInstance.addOption({ value: currency, text: currency });
                            });
                            tomSelectInstance.refreshOptions(false);

                            if (data[0]) {
                                tomSelectInstance.setValue(data[0]);
                            }

                            tomSelectInstance.enable();
                            tomSelectInstance.refreshOptions(false);

                            tomSelectInstance.setValue("");
                        } else {
                            tomSelectInstance.addOption({ value: "USD", text: "USD" });
                            tomSelectInstance.setValue("USD");
                        }
                    },
                    error: function (error) {
                        console.error('AJAX Error:', error);
                    }
                });
            }


            $(document).on('change input', "#amount, #supported_currency, .selectPayoutMethod", function (e) {
                let amount = amountField.val();
                let selectedCurrency = $('#supported_currency').val();
                let currency_type = 1;

                if (!isNaN(amount) && amount > 0) {
                    let fraction = amount.split('.')[1];
                    let limit = currency_type == 0 ? 8 : 2;

                    if (fraction && fraction.length > limit) {
                        amount = (Math.floor(amount * Math.pow(10, limit)) / Math.pow(10, limit)).toFixed(limit);
                        amountField.val(amount);
                    }
                    checkAmount(amount, selectedCurrency, selectedPayoutMethod)
                } else {
                    clearMessage(amountField)
                    $('.showCharge').html('')
                }
            });

            function checkAmount(amount, selectedCurrency, selectedPayoutMethod) {
                $.ajax({
                    method: "GET",
                    url: "<?php echo e(route('user.payout.checkAmount')); ?>",
                    dataType: "json",
                    data: {
                        'amount': amount,
                        'selected_currency': selectedCurrency,
                        'selected_payout_method': selectedPayoutMethod,
                    }
                }).done(function (response) {
                    let amountField = $('#amount');
                    clearMessage(amountField);

                    if (response.status) {
                        btnStatus = true;
                        $(amountField).addClass('is-valid');
                        $(amountField).closest('div').find(".valid-feedback").html(response.message);
                        showCharge(response, base_currency);
                    } else {
                        btnStatus = false;
                        $(amountField).addClass('is-invalid');
                        $(amountField).closest('div').find(".invalid-feedback").html(response.message);
                        $('.showCharge').html('');
                    }

                    submitButton();
                });
            }

            function submitButton() {
                if (btnStatus) {
                    $('.submitBtn').prop('disabled', false);
                } else {
                    $('.submitBtn').prop('disabled', true);
                }
            }

            function clearMessage(fieldId) {
                $(fieldId).removeClass('is-valid')
                $(fieldId).removeClass('is-invalid')
                $(fieldId).closest('div').find(".invalid-feedback").html('');
                $(fieldId).closest('div').find(".is-valid").html('');
            }

            function showCharge(response, currency) {
                let txnDetails = `<ul class="list-group">
						<li class="list-group-item d-flex justify-content-between">
							<span><?php echo e(__('Amount In')); ?> ${response.currency} </span>
							<span class="text-success"> ${response.amount} ${response.currency}</span>
						</li>
						<li class="list-group-item d-flex justify-content-between">
							<span><?php echo e(__('Charge')); ?></span>
							<span class="text-danger">  ${response.charge} ${response.currency}</span>
						</li>

						<li class="list-group-item d-flex justify-content-between">
							<span><?php echo e(__('Payout Amount')); ?></span>
							<span class="text-info"> ${response.net_payout_amount} ${response.currency}</span>
						</li>
						<li class="list-group-item d-flex justify-content-between">
							<span><?php echo e(__('Exchange Rate')); ?></span>
							<span class="text-info"> 1 ${currency} <i class="bi bi-arrow-left-right"></i>  ${response.conversion_rate} ${response.currency}</span>
						</li>
						<li class="list-group-item d-flex justify-content-between">
							<span><?php echo e(__('Payout Amount')); ?> <sub>(In Base Currency)</sub></span>
							<span class="text-info"> ${response.net_amount_in_base_currency} ${currency}</span>
						</li>
					</ul>`;
                $('.showCharge').html(txnDetails)
            }

        });

    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        @media (max-width: 767px) {
            .payment-container-list {
                display: none;
            }
        }

        /* Show gateway list on desktop */
        @media (min-width: 768px) {
            #showGatewaysButton {
                display: none;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(template().'layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/user/payout/request.blade.php ENDPATH**/ ?>